/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/**
 * This class contains various operations that allows the Generic Adapter
 * to run within Eclipse.  This class is where all of the workbench interaction
 * should be placed.  Anyone who uses wither the class object or instances of
 * this class must code in such a mannor as to handle linkage/resolution problems
 * at runtime.  This is because the Eclipse runtime is not nessesary to run the
 * Generic Adapter.
 * 
 * @author rduggan
 * @author paules
 */
public class AdapterPlugin extends Plugin {

    private static AdapterPlugin instance = null;

    public AdapterPlugin(IPluginDescriptor descriptor) {

        super(descriptor);

        if (instance == null) {
            instance = this;
        }
    }

    public static AdapterPlugin getPlugin() {
        return instance;
    }

    public static ResourceBundle getResourceBundle() {
        try {
            return (getPlugin().getDescriptor().getResourceBundle());
        }
        catch (Exception e) {
        }

        return null;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    /**
     * Locate all of the IContextListeners that have registers via the extension point.
     * @return a java.util.List containing the IContextListener instances.
     */
    public static List getContextListeners() {

        IConfigurationElement[] elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.adapter", "contextListener");
        
        List results = new ArrayList();
        
        for (int i = 0; i < elements.length; i++) {
        
            IConfigurationElement elem = elements[i];

            try {
                IContextListener listener = (IContextListener) elem.createExecutableExtension("name");
                results.add(listener);
            }
            catch (Throwable e) {
            }
        }

        return results;
    }

    public static IComponent getComponent(String classname) {

        IComponent component = null;
        IConfigurationElement[] elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.adapter", "adapterComponent");

        for (int i = 0; i < elements.length; i++) {

            IConfigurationElement elem = elements[i];

            if (elem.getAttribute("name").equals(classname)) {

                try {

                    component = (IComponent) elem.createExecutableExtension("name");

                    return component;
                }
                catch (Throwable e) {
                }
            }
        }
        return component;
    }
}
