/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/* Created on Oct 14, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author sdirkers
 *
 * This class handles cookies in the Cookie Cache. It stores them and then
 * retrieves them for Http Request Headers.
 */
package org.eclipse.hyades.test.http.runner;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

import org.eclipse.hyades.test.http.runner.internal.exec.Cookie;
import org.eclipse.hyades.test.http.runner.internal.exec.CookieLL;
import org.eclipse.hyades.test.http.runner.internal.exec.DomLL;
import org.eclipse.hyades.test.http.runner.internal.exec.URILL;






public class HttpCookieCache {
//      exception for unexpected cookie conditions.  Assumed used DynamicGetCookie & DynamicSetCookie.
          
        /**
         * 
         * @author sdirkers
         *
         * this little inner class handles what few exceptions for invalid cookies
         * might come up
         */
        public class InvalidCookieException extends Exception {
          public InvalidCookieException(String msg)
            {
              message = msg;

            }
          public String getMessage()
            {
                return message;
            }
          public String message;
        }
        // called for each TestSuite, only once
        public HttpCookieCache()
        {
       if (CookieCache == null)

              CookieCache = new LinkedList();
          specdom = new String[7];
          specdom[0]=".com";
          specdom[1]=".edu";
          specdom[2]=".net";
          specdom[3]=".org";
          specdom[4]=".gov";
          specdom[5]=".mil";
          specdom[6]=".int";

          //this will have objects added as cookies are added
        }
        /**
        * This is the routine that sets dynamic cookies into the cache 
        */
        public void DynamicSetCookie(HttpRequest request, HttpResponse response)
         {
                int sti;
                int stp;
                int rc;
                Cookie chip;
                String setckhdr;
 
 
                setckhdr = new String("");
                /* for each Set-Cookie in HttpReponse: */

                // extract      setckhdr out of HttpResponse

        
             
                           // HttpHeader[] headers = response.getHeaders("Set-Cookie");
                             HttpHeader[] headers = response.getHeaders("Set-Cookie");
                             for (       int i = 0; i < headers.length; i++)
                              {


                                 try {
                                         setckhdr = new String(headers[i].getValue());
                               //        if (setckhdr.indexOf(0x0a)==-1)
                              //          {
                                           //           System.out.println("Set-Cookie is :" + setckhdr);
                                                                                        //                      return;
                               //         }






                       // is there a set-cookie?
                       //  if there is, is it already in the cache?
                       //  if so and new one is obsolete, delete old, no replace
                       //   if not and new one is obsolete, discard
                       //  else: if new one not expired:
                          //  if already exists, replace with this new one
                           //  otherwise, add this new one

                             //    To add this cookie
                             //      find domain ( if new, add)
                             //      find path    ( if new, add)
                             //      find cookie   ( if new, add, else replace)



                              chip = new Cookie();


                           rc = parse_cookie( request, chip, setckhdr);
                           if (rc ==0)
                              rc= search_repl_cache(  chip);
                                                  
                         

                            }  // try
           
                            catch(InvalidCookieException ice)
                               {
                               //  	System.out.println("Exception on cookie:" + ice.getMessage());
                                   }
                            catch(Exception e)
                              {
                              	e.printStackTrace();
                              }
      
                       }
      
           return ;

        }

        /**
        * This is the routine to get a dynamic cookie from the Cache
        */
        public void DynamicGetCookie(HttpRequest request)
        {

                // find all the cookies on path and domain of request
                // collect in a StringBuffer
                // return in a HttpHeader object

                int i, j, k, saven;
                 int dsize=CookieCache.size();
                int psize,csize;
                LinkedList fndcookies,clist;
                HttpHeader[] hdrs;
     try 
       {          
    
       StringBuffer ckbuf = new StringBuffer();
       fndcookies = new LinkedList();

       saven = -1;
       //search cookie headers in request object, put static cookies in a string array

       for (i = 0; i < CookieCache.size(); i++)
             {
                        if (domain_match(request.getHost(),((DomLL)CookieCache.get(i)).domain ) != -1)
                          {
                                psize = ((LinkedList) ((DomLL)CookieCache.get(i)).UriLL).size();
                           //     System.out.println("Upsize = "+ psize);
                for (  j = 0; j < psize; j++)
                 {
                                  if (path_match(((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).uripath,request.getAbsolutePath()) !=-1)
                                     {
                                        csize = ((LinkedList)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr).size();
                             //           System.out.println("csize = " + csize);
                       for ( k = 0; k < csize; k++)
                         {
                                                if (get_time_left(((CookieLL)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie.expires) !=1)
                                                 {

                                 if (((CookieLL)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie.sslflag == request.getSecure())
                                   {
                                         if (((CookieLL)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie.cval.endsWith("\r\n") == true)
                                          {
                                                                //              make sure cookie ends in ;
                                           int cvllgn = ((CookieLL) ((URILL) ((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie.cval.length();
                                           String Trimmed= new String(((CookieLL) ((URILL) ((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie.cval.substring(0,cvllgn-1));
                                           StringBuffer Trimmed_plus = new StringBuffer(Trimmed);
                                           Trimmed_plus.append(";");
                                        synchronized(lock1) {

                                           ((CookieLL)((URILL) ((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie.cval = new String(Trimmed_plus.toString());
                                        }
                                          }
                                          // add cookie in to linked list of 'found' cookies
                                          fndcookies.add(((CookieLL)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie);

                                                                 //    ckbuf.append(((CookieLL) ((URILL) ((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).thecookie.cval);

                                                                 //    ckbuf.append(" ");

                                   }

                                                 }
                                                else
                                                  {
                                                  synchronized(lock1){

                                                          ((LinkedList)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr).remove(k);
                                                    }
                                                 }
                         }
                                     }

                 }

                          }
             }
             // put static cookies remaining in fndcookies if they aren't duplicates
             HttpHeader[] reqhdrs = request.getHeaders();
             int eqi;  int sb;
             String cnam = null;
          //   System.out.println("reqhdrs.length = " + reqhdrs.length);
             for ( int n = 0; n < reqhdrs.length; n++)
               {
                if (reqhdrs[n].getName().equalsIgnoreCase("Cookie"))
                 {
                 	saven = n;
                 //   System.out.println(" saw a recorded cookie list, cookie = " + reqhdrs[n].getValue());
                       //separate out the list
                         clist = sep_cookies(reqhdrs[n]);
                      for ( j = 0; j < clist.size(); j++)
                       {
                        if ((eqi=((String)clist.get(j)).indexOf("="))!=-1)
                            cnam = new String(((String)clist.get(j)).substring(0,eqi).trim());
                        if (eqi != -1)
                            {
                               int m; boolean fnd = false;
                         //    System.out.println("about to check for captured cookie in fndcookies list");
                               for (m = 0; m < fndcookies.size(); m++)
                                  {
                                  	
                                    if ((((Cookie)fndcookies.get(m)).cname).equals(cnam))
                                    {
                                      fnd = true;
                                      break;
                                     }
                                  }
                                if (fndcookies.size()==0 || fnd == false) {
                           /* invent new cookie*/
                                  Cookie statc = new Cookie();
                                  makecapcookie((String)clist.get(j),statc, fndcookies, eqi, request, cnam);
                               }

                           }
                       } 

                 }
               }
              
             // reorder cookies according to path (most specific to least)
             LinkedList newchain = new LinkedList();
             int flen = fndcookies.size();
             if (fndcookies.size() >0) {
              newchain.add(fndcookies.get(0));
              int q; int qlen;
               for (int l = 1; l < flen; l++)
                {
                 // put longest paths first, insertion sort
                qlen = newchain.size();
                        for ( q=0; q < qlen; q++)
                         {

                           if ( ((Cookie)fndcookies.get(l)).path.length() >= ((Cookie)newchain.get(q)).path.length())
                            {
                              newchain.add(q,fndcookies.get(l));
                              break;
                                    }
                             }
                            if ( q >=qlen)
                               newchain.add(fndcookies.get(l));
                }
                // turn chain into StringBuffer

                for ( int z = 0; z < newchain.size(); z++)
                {
                  ckbuf.append(((Cookie)newchain.get(z)).cookie);
                  ckbuf.append(" ");
                }


             }
             else
               return ;
             // make sure ckbuf ends in 0x0d0a instead of '; '
             ckbuf.delete(ckbuf.length()-2,ckbuf.length()+1);
             HttpHeader CookieHdr = new HttpHeader();
             CookieHdr.setName("Cookie");
             CookieHdr.setValue(ckbuf.toString());
          //   System.out.println("Cookie being returned is..Cookie: "+ ckbuf.toString());
             //check to see if there is already a Cookie hdr
             // if so replace
             if (saven >=0)
               {
               	  // make sure we only return ONE header
               	 request.removeHeaders("Cookie");
             //  	 reqhdrs[saven].setValue(ckbuf.toString());
               }
               
             
             //  add CookieHdr to Request and return
             request.addHeader(CookieHdr);
     }
     catch(Exception e)
      {
      	e.printStackTrace();
      }

                return ;
          
        }


        /**
        * this routine turns a captured cookie into a cookie object and lists it with fndcookies
        */
        protected void makecapcookie(String reqhdrs, Cookie statc, LinkedList fndcookies, int eqi, HttpRequest request, String cnam)
          {
            int sb;
            StringBuffer strb = new StringBuffer(reqhdrs.substring(eqi+1));
                                  if (strb.toString().endsWith(";") == false)
                                    {
                                       if (strb.toString().endsWith("\r\n")==true)
                                         {
                                           sb = strb.toString().indexOf("\r\n");
                                           strb.replace(sb,sb+2,"; ");
                                           strb.delete(sb+1, sb+2);
                                                        }
                                       // neither \r\n nor ; ??
                                       else
                                         strb.append(";");
                                    }
                                  statc.setcookie(cnam,strb.toString());
                                  statc.setsslflag(request.getSecure());
                                  statc.setdomain(request.getHost());
                                  statc.setpath(request.getAbsolutePath());
                                  // add it into chain ( at beginning because path is whole url)
                                  fndcookies.addFirst(statc);


          }
  
         /**
         * this routine separates the captured cookies in the request hdr 
         */

        protected LinkedList sep_cookies(HttpHeader reqhdr)
          {
            LinkedList clist = new LinkedList();
           

            StringTokenizer st = new StringTokenizer(reqhdr.getValue(),";");
            while (st.hasMoreTokens())
              {
                clist.add(st.nextToken()+";");
              }                         
            return clist;

          }

        /**
        * this routine is for prepopulation ONLY
        */
        public int AddCookie( String Name, String Value,String Domain, String Path, String Expires, boolean secure)
                {
                        boolean isip;
                        int rc;
                        String sec="";
                    // is this cookie already in cache?
                    // if so, replace,
                    //  else add
                   //first make this cookie
                   String ckie = new String(Name + "." + Value);
                   isip = false;
                
                  if (!(Domain==null)){ 
                  
                   if (!(Domain.equals(""))){
                   
                     if (is_ipaddr(Domain)==1)
                       isip = true;
                     else isip =false;
                   }
                  }
                   
                   if (secure==true)
                     sec = new String("; secure"); 
               //    System.out.println("Attempting to create Set-Cookie: "+Name+"="+Value+"; domain="+Domain+"; path="+Path+"; expires="+Expires+sec);
                   Cookie static_cookie = new Cookie(Name, Value, secure, Expires,Domain, Path,0, isip);
                   if ( static_cookie.path == null || static_cookie.domain == null || static_cookie.cname==null)
                       return -1;
               //    else
			//	     System.out.println("Created Set-Cookie: "+Name+"="+Value+"; domain="+Domain+"; path="+Path+"; expires="+Expires+sec);


             rc    = search_repl_cache(static_cookie);
           return rc;
    }

    //this routine is for fixing prepopulation, reserved for future
    public void deleteCookie(String Domain, String Path, String Name, String Value)
    {
    }

    /**
    *this routine is for clearing a populated Cache
    */
    public void clearCookieCache()
        {
          int i, CCS=CookieCache.size()-1;
          int j, Urisize=0;
          int k, CkCSize=0;
          synchronized(lock1)
            {
            	for (i=CCS; i >=0; i--)
            	{
            	  Urisize = ((LinkedList) ((DomLL)CookieCache.get(i)).UriLL).size()-1;
				  for (j=Urisize; j >=0; j--)
				    {
						CkCSize = ((LinkedList)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr).size()-1;
						for (k=CkCSize; k >=0; k--)
						 {
							((LinkedList)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr).remove(k);
						 }
					    ((LinkedList) ((DomLL)CookieCache.get(i)).UriLL).remove(j);
				    }
				  CookieCache.remove(i);  
            	}    
            }
        }

        /**
         * This routine searches the cookie cache
         * @param chip  the cookie we are looking to place in cache
         * 
         * @return  successful 
         */
        public int search_repl_cache( Cookie chip)
         {
           int DomCCsize=CookieCache.size();
           int i,j,k;
           int UriSize =0;
           int CkCSize = 0;
           boolean done = false;



          synchronized(lock1){

            done = false;
                // is this domain linked onto the cache?
              //  System.out.println("Size of CookieCache= "+ CookieCache.size());
            for (i = 0; i < CookieCache.size() && !done; i++)
             {
                        if (domain_match(((DomLL)CookieCache.get(i)).domain, chip.domain) ==0)
                          {
                                UriSize = ((LinkedList) ((DomLL)CookieCache.get(i)).UriLL).size();
                           //     System.out.println("UriSize = "+ UriSize);
                for (  j = 0; j < UriSize  && !done; j++)
                 {
                                  if (path_match(((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).uripath,chip.path) ==0)
                                     {
                                        CkCSize = ((LinkedList)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr).size();
                                   //     System.out.println("CkCSize = " + CkCSize);
                       for ( k = 0; k < CkCSize && !done; k++)
                         {
                                                if (cookie_match(((CookieLL)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)), chip.cname) ==0)
                                                 {

                                                    int trc;
                                // Should this cookie be deleted?
                               if ((trc=get_time_left( chip.expires))==0)
                                    //replace cookie
                                     replace_cookie(i,j,k,chip);
                               else
                                 if (trc ==1)
                                   ((LinkedList)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr).remove(k);
                                done = true;
                                break;
                                                 }
                        }
                      if (k >= CkCSize)
                       {
						// Should this cookie be skipped?
					    if (get_time_left( chip.expires)==0)
                           add_new_cookie(i,j,chip);
                        done = true;

                         break;

                       }
                                   }
                 }
                                 if (j >= UriSize && !done)
                                     {

                                       add_new_path(i, chip);
                                       add_new_cookie(i,j, chip);
                                       done = true;
                                       break;


                                     }

                          }

             }
             if (i >= DomCCsize && !done)
               {
				// Should this cookie be skipped?
					if (get_time_left( chip.expires)==0)
					  {
					      add_new_domain(chip);
                          add_new_path(i, chip);
                          add_new_cookie(i,0,chip);
					  }
                      done = true;

               }

            }
                return 0;
         }

         protected int path_match(String path1, String path2)
         {
            //does path1 = path 2 exactly?
             if (path1.equals(path2))
                return 0;

            //is path1 lexically contained in path 2?
            // remove trailing slashes from both if they exist
            
            StringBuffer tmppath1 = new StringBuffer(path1);
            StringBuffer tmppath2 = new StringBuffer(path2);
            if (path1.length() > 1)
              {
                if (tmppath1.charAt(tmppath1.length()-1)=='/')
                  tmppath1.deleteCharAt(tmppath1.length()-1);
              }
            if (path2.length() > 1)
              {
                if (tmppath2.charAt(tmppath2.length()-1) == '/')
                  tmppath2.deleteCharAt(tmppath2.length()-1);
                  
              }
            String tpath1 = new String(tmppath1);
            String tpath2 = new String(tmppath2);
            
             if (tpath2.startsWith(tpath1))
                return 1;

            return -1;
         }

         protected void replace_cookie(int i, int j, int k, Cookie chip)
          {
              ((CookieLL)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).setCookie(chip);
          //    System.out.println("Cookie is replaced: " + chip.cookie);
          //   Date myd = new java.util.Date();
           //  ((CookieLL)((URILL)((DomLL)CookieCache.get(i)).UriLL.get(j)).cookieptr.get(k)).set_time_cookie_stored(0);

          }
     protected int cookie_match(CookieLL cookiep, String ckienam)
          {
                if (cookiep.getCookie().cname.equals(ckienam))
               return 0;
            else return -1;
          }

          protected int get_time_left( String exp)
           {
                long now;
                String pattern;
                String pattern1;
                String pattern2;
                
                java.util.Date longdate;
                 //Need to know what time it is now ( in GMT time),
                 // and what time the expires string is for

                if (exp == null) return 0;

                TimeZone tz = TimeZone.getTimeZone("GMT");
                Calendar cal = Calendar.getInstance(tz,Locale.US);

            //    now = cal.getTimeInMillis();
                now = cal.getTime().getTime();


                Long explong = new Long(0);
                pattern1 = new String("dd-MMM-yyyy HH:mm:ss z");
                pattern2 = new String("dd-MMM-yy HH:mm:ss z");
                pattern = new String(pattern1);
                             
                /* fix up this string to trip over as little as possible*/  
                /* because there are websites who cannot deign to follow the MUST*/
                /* pattern on the version 0 cookie Spec ( NEtscape), we must */
                /* all but parse this out ourselves */
                
                              
                StringBuffer expmod = new StringBuffer(exp);
                int comma = expmod.toString().indexOf(",");
                if ( comma == -1)
                  {
                    /* these people just cannot follow the pattern*/
                    /* find the first NUMBER and assume it is a day */
                   int i;
                   for (i=0; i < exp.length(); i++)
                     {
                  //   	System.out.println("exp.charAt="+ exp.charAt(i));
                     	if (exp.charAt(i)>= '0' && exp.charAt(i)<='9' )
                     	  break;  	
                     }
                    if (i < exp.length())
                       comma = i - 2;
                  }
                expmod.delete(0,comma+2);
                if (expmod.substring(0,1).equals(" "))
                   expmod.replace(0,1,"0");
                if (expmod.substring(2,3).equals(" "))
                   expmod.replace(2,3,"-");
                if (expmod.substring(6,7).equals(" "))
                   expmod.replace(6,7,"-");  
                 /* but now, let's watch out for the people who just */
                 /* can't bring themselves to express the year in 4 digits*/
                 /* like the spec says */
                if (expmod.substring(9,10).equals(" "))
                   pattern = new String(pattern2); 
                String exp1 = new String(expmod);
                
                try
                                   {
                                          SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);

                                          longdate = sdf.parse(exp1);
                                          explong = new Long(longdate.getTime());
                                   }
                                  catch(Exception e)
                                   {
                                       //   System.out.println("Exception on expires = " + exp + " is: " + e.getMessage() );
                                          return -1;
                                }



                        // or should we really be comparing 2 Calendar or Date objects,
                        // now that we can set them with millis?

                        if (explong.longValue()> now)
                          return 0;
            else return 1;  //expired already






           }

     
         /**
          * 
          * @param dom1  first domain to compare
          * @param dom2  second domain to compare
          * @return  0 for perfect match, 1 for tail match, -1 for no match
          */
         protected int domain_match(String dom1, String dom2)
         {
                int retc1;
                int retc2;
                String tdom;

            // do they match exactly?
            if (dom1.equalsIgnoreCase(dom2))
               return 0;


           // does domain 2 tail-match domain 1?
           // check that this is NOT an ipaddr...needs an alpha
           retc1 = is_ipaddr(dom1);
           retc2 = is_ipaddr(dom2);


           if (retc1 ==0 && retc2 == 0)
            {
                                StringBuffer tempdom = new StringBuffer(".");
                                if (!dom2.startsWith("."))
                                     {
                                        tempdom.append(dom2.toLowerCase());
                                        tdom = new String(tempdom);
                                     }
                                else
                                    tdom = new String(dom2.toLowerCase());
                        if (dom1.length() > dom2.length())
                           if (dom1.toLowerCase().endsWith(tdom))
                              return 1;
                }

            return -1;

         }
         
        /**
        * this is a quick check to see if a domain is specified by ip addr 
        * it does not go so far as to check that the actual numbers used in the 
        * addr are valid for an ip address. That is assumed to be the responsibility 
        * of the server 
        */
        
        protected int is_ipaddr(String dom)
         {
                char c;  int ip = 1;
                                   for (int i = 0; i < dom.length(); i++)
                                          {
                                                if (!((c = dom.charAt(i)) >='0' && (c <= '9' ) || c== '.'))
                                                  {
                                                     ip = 0;
                                                     break;
                                              }
                                          }
        return ip;
         }

        protected int add_new_domain( Cookie chip)
         {
           DomLL dom = new DomLL();
           dom.setdomain(chip.domain);
           // If this is an ip addr, also set ipaddr

           dom.setipaddr(chip.isip);
           // hook this element into CookieCache
           CookieCache.add(dom);

                return 0;
         }

        protected int add_new_path(int idx,  Cookie chip)
         {
                URILL uri = new URILL(chip.path,(DomLL)CookieCache.get(idx));
                ((LinkedList)((DomLL)CookieCache.get(idx)).UriLL).add(uri);
                return 0;
         }


              /* this routine is NOT to be used except for initialization*/
        protected int add_new_cookie(int idx, int jdx, Cookie chip)
        {
                 // this may not really be needed except for maxage at Version 1
          //  java.util.Date date = new java.util.Date();

                CookieLL ckl = new CookieLL(chip,0,((URILL)((DomLL)CookieCache.get(idx)).UriLL.get(jdx)));

                ((LinkedList) ((URILL) ((DomLL)CookieCache.get(idx)).UriLL.get(jdx)).cookieptr).add(ckl);
                
                return 0;
        }

        /**
        *  This routine parses a cookie before setting it 
        */
        public int parse_cookie(HttpRequest req, Cookie chip, String setckhdr) throws InvalidCookieException
                {
                  int eqi;
                  int rc = 0;
                  int semi;
                  int vattr;
                  int domset=0;
                  int nneqi,nseqi,nnsmi=0;
                  StringBuffer Message=null;

                  String cv, ts;
               // save name=value in cookie object
                 rc = 0;
                 domset = 0;
                 Message = new StringBuffer();

                 if ((eqi=setckhdr.indexOf("="))!= -1)
                  {
               //      back up to first non-whitespace
                      ts = new String(setckhdr.substring(0,eqi).trim());

               //      get cookie value
                     if ((semi = setckhdr.indexOf(";"))!=-1)
                         cv = new String(setckhdr.substring(eqi+1,semi+1).trim());
                     else
               //           assume ONLY name=value but add ;
                        {
                         cv = new String(setckhdr.substring(eqi+1).trim());
                         StringBuffer sb1 = new StringBuffer(cv);
                         sb1.append(";");
                         cv = new String(sb1);
                 //        System.out.println("cv=" + cv);
                         semi = eqi + cv.length();
                        }
                  }
                  else
                    {
                      Message.append("Error: No NAME=VALUE detected. Http Header= " + setckhdr );
                      InvalidCookieException ecv1 = new InvalidCookieException(Message.toString());
                      throw ecv1;                    
                 
                      
                    }

                 chip.setcookie(ts, cv);
                 chip.setversion(0);
                 chip.setdomain(req.getHost());

                 if  (semi <= setckhdr.length())
                  {

                          if ((vattr=findattr("Version",setckhdr,semi))!=-1)
                  //  if ((vattr=setckhdr.substring(semi).indexOf("Version"))!= -1)
                       {
                     //   System.out.println("Only version 0 of cookies is supported. Version string detected (for higher versions). Cookie will be skipped.");
                        return -1;
				       }

                      if ((nneqi=findattr("domain",setckhdr,semi))!=-1)
                     //  if ((nneqi=setckhdr.substring(semi).indexOf("domain"))!=-1)
                         {
                            if ((nseqi=setckhdr.substring(nneqi+semi).indexOf("="))!=-1)
                              {
                          //      System.out.println("nneqi = " + nneqi + "nseqi=" + nseqi + " semi=" + semi);
                                nnsmi = setckhdr.substring(nneqi+semi).indexOf(";");
                            //    System.out.println("nnsmi = " + nnsmi);
                                domset = 1;
                                if (nnsmi != -1)
                                  chip.setdomain(new String(setckhdr.substring(semi+nneqi+nseqi+1,semi+nneqi+nnsmi)));
                                else
                                  chip.setdomain(new String(setckhdr.substring(semi+nneqi+nseqi+1).trim()));

                              }


                      }
                    
                   if (is_ipaddr(chip.domain)==1)
                       chip.isip = true;


                         // if ((nneqi=setckhdr.substring(semi).indexOf("path"))!=-1)
                            if ((nneqi = findattr("path",setckhdr,semi))!=-1)
                                 {
                                   if ((nseqi=setckhdr.substring(nneqi+semi).indexOf("="))!=-1)
                                          {
                                       
                                        nnsmi = setckhdr.substring(nneqi+semi).indexOf(";");
                                       
                                        if (nnsmi != -1)
                                                  chip.setpath(new String(setckhdr.substring(semi+nneqi+nseqi+1,semi+nneqi+nnsmi)));
                                                else
                                                  chip.setpath(new String(setckhdr.substring(semi+nneqi+nseqi+1).trim()));
                                         }
                     }
                     else
                         chip.setpath(req.getAbsolutePath());

                      if ((vattr=findattr("secure",setckhdr,semi))!=-1)
                  //   if ((vattr=setckhdr.substring(semi).indexOf("secure"))!=-1)
                          chip.setsslflag(true);
                      else
                           chip.setsslflag(false);

                    if ((nneqi=findattr("expires",setckhdr,semi))!=-1)
                //              if ((nneqi=setckhdr.substring(semi).indexOf("expires"))!=-1)
                                          {
                                                if ((nseqi=setckhdr.substring(semi+nneqi).indexOf("="))!=-1)
                                                   {
                                                         nnsmi = setckhdr.substring(semi+nneqi).indexOf(";");
                                                         if (nnsmi != -1)
                                                           chip.setexpires(new String(setckhdr.substring(semi+nneqi+nseqi+1,semi+nneqi+nnsmi)));
                                                         else
                                                           chip.setexpires(new String(setckhdr.substring(semi+nneqi+nseqi+1).trim()));
                                                  }
                                          }

                          }
                    //  Now that cookie is parsed...
           //    Check that domain is valid for this host
               if (chip.domain != null)
                {
                 rc = check_dots(chip, Message);
                 if (domset==1 && rc == 0)
                    {
                       rc = check_ondom(req, chip, Message);
                    }
                }
                    if (rc !=0)
                     {
                     	InvalidCookieException ecv =new InvalidCookieException(Message.toString());
                     	throw ecv;
                     }
                    return rc;
                }

       /**
       * This routine specifically searches for attribute strings of cookies
       */
        protected int findattr(String attr,String str, int semi)
         {
           int idx;  int i; int j; int accumidx=0;
           boolean secfnd = false; boolean eqfnd = false;
           String tmpstr = new String(str.substring(semi));
           tmpstr = tmpstr.toLowerCase();


           while((idx=tmpstr.indexOf(attr.toLowerCase()))!=-1)
             {
                 accumidx = accumidx + idx;
                 eqfnd = false;
                 secfnd = false;
          //       System.out.println("Looking for attr=" + attr + " in " + tmpstr);
                for ( i =idx+attr.length(); i < tmpstr.length();i++)
                  {
                        if (tmpstr.substring(i,i+1).equals(" ")) continue;
                        if (attr.toLowerCase().equals("secure"))
                         {
                           
                          
                              
                           // parse back looking for blanks then ;
                              secfnd =parse_secure(idx, tmpstr);
                              if (secfnd == true)
                                break;
                          
                         
                         }
                        else
                            if (tmpstr.substring(i,i+1).equals("=")) 
                               eqfnd = true;
                        break;
                  }
                 if ( eqfnd == true ||   parse_secure(idx,tmpstr) == true)
              //      System.out.println("Found attr at idx = " + idx + " attr= " + tmpstr.substring(idx));
                  return accumidx;

          
                if (i >= tmpstr.length()) break;
                accumidx = accumidx + i;
                tmpstr = new String(tmpstr.substring(i));

             }

           return -1;

         }
     
    protected boolean parse_secure(int idx, String tmpstr)
      {
         int j;
         
         
         j = idx;
         if (j <1)return false;
	   while (tmpstr.substring(j-1,j).equals(" ") && j >0)
			   j= j- 1;
		if (tmpstr.substring(j-1,j).equals(";")) 
		  return true;
		else 
		  return false;
      }
     /**
     * This routine checks that a host setting a cookie belongs to the  
     *  domain of the cookie.
     */
        protected int check_ondom(HttpRequest req, Cookie chip, StringBuffer Message)
          {
            int retc1;
            String tdom;


                // Do the domains match exactly?
                   if (chip.domain.toLowerCase().equals(req.getHost().toLowerCase()))
                         return 0;


                // Is the       Host on the domain that was specified?  (better not be an ipaddr)
                 retc1 = is_ipaddr(req.getHost());

                StringBuffer tempdom = new StringBuffer(".");
                                                           if (!chip.domain.startsWith("."))
                                                                 {
                                                                  tempdom.append(chip.domain);
                                                                  tdom = new String(tempdom);
                                                                 }
                                                          else
                                                                tdom = new String(chip.domain);

                if (chip.domain.length() < req.getHost().length())
                 {

                if ((retc1 == 0 && !chip.isip) && (req.getHost().toLowerCase().endsWith(tdom.toLowerCase())))

                       return 0;

                   else
                    {
                        Message.append(" Host: " + req.getHost() + " is not on domain = " + chip.domain);
                        
                    return -1;
                   }
            }
           else
             {
                Message.append(" Host: " + req.getHost() + " is not on domain = " + chip.domain);
                return -1;
             }

          }

     /**
     * this routine checks that the domain of a cookie has an appropriate
     * number of dots.
     */
        protected int check_dots(Cookie chip, StringBuffer Message)
          {
			if (chip.domain.length() >=4)
             {
			   for (int i = 0;  i < specdom.length  ; i++)
                 {
                    if (chip.domain.substring(chip.domain.length()-4).equalsIgnoreCase(specdom[i]))
                        {
                           if (chip.domain.indexOf(".")< chip.domain.lastIndexOf("."))
                             return 0;
                           else
                             {
                             	//  this is being commented out because IE doesn't care
                             	// even though this is AGAINST the cookie spec
                             	//  Je proteste!  Someday some virus will exploit this, I predict...
                             	
                              //  Message.append(" Error: Domain must have at least 2 dots for special domain = " + chip.domain);
                         
                              // return -1;
                                return 0;  // allow anyway
                             }
                         }
                      }
                   }
                  int cnt = 0;

                  for (int i = 0; i < chip.domain.length(); i++)
                     {
                        if (chip.domain.substring(i,i+1).equals("."))
                          cnt++;
                      }
                        // if NO dots, assume domain is local
                  if (cnt < 3 && cnt > 0)
                    {
                      Message.append(" Error: Domain must have at least 3 dots, domain = " + chip.domain);
                   
                      return -1;
                    }

                return 0;
          }



        public LinkedList CookieCache;

      
        private byte[] lock1 = new byte[0];
        String[] specdom;

}
