/*
 * Created on May 21, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.execution.local;


import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SessionImpl extends ExecutionComponentImpl implements ISession {
	protected INode node;
	protected Agent agent;

	public SessionImpl(INode node, Agent agent) {
		super();  
		this.node=node;
		this.agent=agent;
		createAgentListener();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.ISession#release()
	 */
	public void release() {
		// TODO Auto-generated method stub

	}
	
	/**
	 * We need to be able to navigate back to our node.
	 * 
	 */
	public INode getNode() {
		return node;
	}	
	
	/**
	 * This creates a agent listener for the embedded agent on the remote session.  
	 * This listener is responsible for firing state change events and forwarding 
	 * all the commands to the proper handler.
	 *
	 */
	private void createAgentListener() {
	
		agent.addAgentListener(new AgentListener() {

			public void agentActive(Agent agent) {
				/* Notify our listeners that the state has changed */
				fireStateChangeEvent(new ExecutionComponentStateChangeEvent(SessionImpl.this, READY));
			}

			public void agentInactive(Agent agent) {
				/* Notify our listeners that the state has changed */
				fireStateChangeEvent(new ExecutionComponentStateChangeEvent(SessionImpl.this, DEAD));
			}

			public void error(Agent agent, String errorId, String errorMessage) {
				// TODO Auto-generated method stub
			
			}

			public void handleCommand(Agent agent, CommandElement command) {
				if(command instanceof CustomCommand) {
					CustomCommand custom=(CustomCommand)command;
					try {
						ReturnData returnVal=Marshaller.unmarshalReturnValue(custom.getDataBinary());
						
						Marshaller.queueReturnValue(returnVal);
					}
					catch(Throwable e) {
						e.printStackTrace();
					}
					
				}
			
			}	
		});
	
	}
	
	public void invokeRemote(CustomCommand command) {
		try {
			agent.invokeCustomCommand(command);
		}
		catch(InactiveAgentException e) {
		
		}
	}
	
	public Agent getAgent() {
		return agent;
	}
}
