/*
 * Created on May 21, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.test.execution.local;

import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class Test {


	public void run() {
		/* Create our session */
		INode node=new NodeImpl("rduggan");
		ISession session=null;
		try {
			session=node.connect(null, null);
		}
		catch(Exception e) {
			System.out.println("Error creating session "+e.getMessage());
			return;
		}
		
		try {
		
			/* Get our factory */
			IExecutionComponentFactory factory=ExecutionComponentFactoryImpl.getInstance(session);
			
			/* Configure our factory to use the proper types */
			factory.addExecutionComponent("ENVIRONMENT", "org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl");
			factory.addStub("ENVIRONMENT", "org.eclipse.hyades.execution.local.ExecutionEnvironmentStub");
			factory.addSkeleton("ENVIRONMENT", "org.eclipse.hyades.execution.remote.ExecutionEnvironmentSkeleton");
			
			factory.addExecutionComponent("EXECUTOR", "org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl");
			factory.addStub("EXECUTOR", "org.eclipse.hyades.execution.local.ExecutorStub");
			factory.addSkeleton("EXECUTOR", "org.eclipse.hyades.execution.remote.ExecutorSkeleton");

			
			/* create our environment */
			IExecutionEnvironment exeEnvironment =(IExecutionEnvironment)factory.createExecutionComponentByType("ENVIRONMENT");
			
			session.addChild(exeEnvironment);
			
			OrderedPropertyImpl property=new OrderedPropertyImpl();
			property.setName("PATH");
			property.appendValue("d:\\temp");
			exeEnvironment.addEnv(property);
			
			
			/* create our executor */
			IExecutor executor =(IExecutor)factory.createExecutionComponentByType("EXECUTOR");
			
			/* Add an executor to the environment */
			exeEnvironment.addChild(executor);
			
			//executor.setExecutableObject(null);
			executor.launch();
		}
		catch(ClassNotFoundException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		finally {
			session.release();
		}
	}

	public static void main(String[] args) {
		Test test= new Test();
		test.run();
	}
}
