/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main Testgen plugin
 * @author Ernest Jessee
 */
public class TestgenPlugin extends AbstractUIPlugin {
	/**
	 * The default instance of this plugin
	 */
	private static TestgenPlugin plugin;
	
	/**
	 * The plugin's resource bundle
	 */
	private ResourceBundle resourceBundle;
	
	/**
	 * preference store keys
	 */
	public static final String SELECTED_GENERATOR="selected_generator";	 //$NON-NLS-1$
	
	/**
	 * The constructor.
	 */
	public TestgenPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("org.eclipse.hyades.execution.testgen.TestgenPlugin"); //$NON-NLS-1$
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static TestgenPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= TestgenPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	private ResourceBundle getResourceBundle() 
	{
		return resourceBundle;
	}
	
	
	
	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#initializeDefaultPreferences(org.eclipse.jface.preference.IPreferenceStore)
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store)
	{
		store.setDefault(TestgenPlugin.SELECTED_GENERATOR,"org.eclipse.hyades.execution.testgen.TestGenGenerator.HTTPGenerator"); //$NON-NLS-1$
		
	}

}
