/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.sd.ui.internal.loader.IModelLoader;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.Increment;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;

/**
 * 
 */
public class LogLoader implements IModelLoader{
	
	private EObject mofObject;
	protected Graph graph;
	protected Hashtable agents = new Hashtable();
	protected TRCAgentProxy agentList[] = new TRCAgentProxy[3];
	protected int nextAgent = 0;
	protected int selectedIndex = -1;
	private CorrelationContainerProxy correlationContainerProxy;
	
	public LogLoader() {
		super();
	}
	
	public LogLoader(Object mObject, Graph gr){
		setObjectAndGraph(mObject,gr); 	
	}
	
	public void setObjectAndGraph(Object mObject, Graph gr) {
		mofObject = (EObject)mObject;
		graph = gr; 		
	}
	
	public void load() {

		loadAgents();

		IConfigurationElement correlation = LogCDrawUtils.getCurrentPage().getCorrelationType();

		if (correlation != null)
		{

				BasicEList recordListToCorrelate = new BasicEList();
				String correlationType = null;
				if(correlationContainerProxy==null)
				{	
					ILogRecordCorrelationEngine recordCorrelator = null;
					IConfigurationElement[] filters_correlators = addNodes(correlation, recordListToCorrelate);
					for (int k = 0; k < filters_correlators.length; k++)
					{
						if (filters_correlators[k].getName().equals("LogRecordCorrelationEngine"))
						{
							try 
							{
								recordCorrelator =(ILogRecordCorrelationEngine) filters_correlators[k].createExecutableExtension("class");							
								correlationType =correlation.getAttribute("name");
							}
							catch (CoreException e)
							{
								//System.out.println("CoreException->Correlator");
							}
						}
					}
					if (recordCorrelator != null && agentList.length>0)
					{
						correlationContainerProxy = LoadersUtils.getCorrelationContainerProxy(agentList[0],correlationType,correlation.getAttribute("name"));
						CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
						correlationEngine.setId(correlationType);
						correlationEngine.setType(correlation.getAttribute("log_types"));
						correlationEngine.setName(correlation.getAttribute("name"));
						correlationContainerProxy.setCorrelationEngine(correlationEngine);
						for (int i = 1; i < agentList.length; i++) {
							if (agentList[i]!=null)
							correlationContainerProxy.getCorrelatedAgents().add(agentList[i]);	
						}
						LogCDrawUtils.getCurrentPage().setCorrelationContainerProxy(correlationContainerProxy);
						recordCorrelator.correlate(correlationContainerProxy,recordListToCorrelate);
					}
				}
				createCorrelation();
				
				recordListToCorrelate.clear();
		} 
		else
		{ //point == null -> no correlations :(
			if(correlationContainerProxy!=null)
			{	
				createCorrelation();
			}
			else
			{	
				for (int i = 0; i < agentList.length; i++)
				{
					if (agentList[i] != null)
					{
						loadLog(agentList[i], null);
					}
				}
			}
		}
	}
	
	private IConfigurationElement[] addNodes(IConfigurationElement correlation, BasicEList recordListToCorrelate) {
		IConfigurationElement[] filters_correlators =correlation.getChildren();
		ILogRecordFilter logFilter = null;

		boolean notAdded = true;
		for (int i = 0; i < agentList.length; i++) 
		{
			if (agentList[i] != null) 
			{
				for (int k = 0;k < filters_correlators.length;k++) 
				{
					if (filters_correlators[k].getName().equals("LogRecordFilter")&& agentList[i].getName().equals(filters_correlators[k].getAttribute("log_type")))
					{
						try 
						{
							logFilter =(ILogRecordFilter) filters_correlators[k].createExecutableExtension("class");
							recordListToCorrelate.add(loadLog(agentList[i],logFilter));
							notAdded = false;
						} 
						catch (CoreException e)
						{	
							recordListToCorrelate.add(loadLog(agentList[i], null));
							notAdded = false;
						}
					} 
					else if (agentList[i].getName().equals(filters_correlators[k].getAttribute("log_type"))) 
					{
						recordListToCorrelate.add(loadLog(agentList[i], null));
						notAdded = false;
					}
				}
				if (notAdded)
				{
					recordListToCorrelate.add(loadLog(agentList[i], null));
				}
			}
			notAdded = true;
		}
		return filters_correlators;
	}

	protected RecordList loadLog(TRCAgentProxy agent, ILogRecordFilter logFilter){
		 //System.out.println("TRCLogLoader.loadLog");
		 NodeContainer nodeContainer = addLog(agent);
         RecordList recList=null;
         if(logFilter!=null)
            recList = new RecordList(cbeEventFilter(logFilter.filter(agent.getAgent().getDefaultEvents())),agent.getName());
         else
            recList = new RecordList(cbeEventFilter(agent.getAgent().getDefaultEvents()),agent.getName());
  	     nodeContainer.setName(addRecords(nodeContainer, recList.getList()));
  	     return recList;
	}
		
		
	public EList cbeEventFilter(EList list)
	{
		
		EList filteredList = new BasicEList();
		Iterator it = list.iterator();
		while (it.hasNext()) {
			Object event = it.next();
			if (event instanceof CBECommonBaseEvent) {
				filteredList.add(event);
			}
		}
		return filteredList;		
	}
		
	private void createCorrelation(){
	
	   EList artifactsList=null;
	   EList correlationTypes=null;
	   CBECommonBaseEvent pdArtifact=null;

		   CorrelationContainer correlationContainer = correlationContainerProxy.getCorrelationContainer();
		   for (Iterator iter = correlationContainer.getCorrelations().iterator(); iter.hasNext();) {
			CorrelationEntryImpl element = (CorrelationEntryImpl) iter.next();
			if (element!=null && element.getKey()!=null && element.getValue()!=null)
			{	
				Object ca = element.getKey();
				if(!(ca instanceof CBECommonBaseEvent))
					continue;
			
				addConnections((CBECommonBaseEvent)element.getKey(),(EList)element.getValue());
			}
		   }
	}
		
	  
  
  public void setSelectedIndex(int index){
  	
     selectedIndex = index;	
  }
  
  protected void loadAgents(){

  	if(mofObject instanceof CorrelationContainerProxy)
  	{
  		correlationContainerProxy = (CorrelationContainerProxy)mofObject;
  		for (Iterator iter = ((CorrelationContainerProxy)mofObject).getCorrelatedAgents().iterator(); iter.hasNext();) {
  			TRCAgentProxy trcAgentProxy = (TRCAgentProxy) iter.next();
  			if (trcAgentProxy != null && !trcAgentProxy.eIsProxy())
  			{
  				addAgent(trcAgentProxy);

  			}
  		}
  		IConfigurationElement correlation = getCorrelation(correlationContainerProxy.getCorrelationEngine());
  		if(correlation!=null)
  			addNodes(correlation, new BasicEList());
  		else
  		{
  			if(isInternalCorrelation(correlationContainerProxy))
  			{
  				addAllNodes();
  			}
  		}
  	}else
     if(mofObject instanceof TRCMonitor)
        loadAllAgents((TRCMonitor)mofObject);
     else if(mofObject instanceof TRCNode)
        loadAllAgents((TRCNode)mofObject);
     else if(mofObject instanceof TRCProcessProxy)
        loadAllAgents((TRCProcessProxy)mofObject);
     else if(mofObject instanceof TRCAgentProxy)
        addAgent((TRCAgentProxy)mofObject);	
  }
  
  /**
 * @param correlationContainerProxy2
 * @return
 */
private boolean isInternalCorrelation(CorrelationContainerProxy correlationContainerProxy) {
	for (Iterator iter = correlationContainerProxy.getCorrelatedAgents().iterator(); iter.hasNext();) {
		TRCAgentProxy agentProxy = (TRCAgentProxy) iter.next();
		if(agentProxy.getInternalCorrelations().contains(correlationContainerProxy))
			return true;
	}
	return false;
}

/**
 * 
 */
private void addAllNodes() {
	for (int i = 0; i < agentList.length; i++) 
	{
		if (agentList[i] != null) 
		{
			loadLog(agentList[i],null);
		}
	}
}

protected IConfigurationElement getCorrelation(CorrelationEngine engine) {
  	String name = engine.getName();
  	IPluginRegistry registry = Platform.getPluginRegistry();
  	IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView"); //$NON-NLS-1$
  	if (point != null) {
  		
  		IExtension[] extensions = point.getExtensions();			
  		for (int i = 0; i < extensions.length; i++) {
  			IConfigurationElement[] elements =	extensions[i].getConfigurationElements();
  			for (int j = 0; j < elements.length; j++) {
  				
  				IConfigurationElement elem = elements[j];
  				if ("view".equals(elements[j].getName()) //$NON-NLS-1$
  						&& elements[j].getAttribute("name").equals(name))
  					return elem;
  			}
  		}			
  	}
  	
  	return null;
  }
  


protected void loadAllAgents(TRCMonitor monitor)
	{
		if (monitor != null)
		{
			for (Iterator nodes = monitor.getNodes().iterator(); nodes.hasNext();)
			{
				TRCNode node = (TRCNode) nodes.next();
				if (node != null)
				{
					loadAllAgents(node);
				} // node null test
			} // nodes loop  
		}
	}
	protected void loadAllAgents(TRCNode node)
	{
		for (Iterator processProxies = node.getProcessProxies().iterator(); processProxies.hasNext();)
		{
			TRCProcessProxy processProxy = (TRCProcessProxy) processProxies.next();
			if (processProxy != null)
			{
				loadAllAgents(processProxy);
			}
		} // processProxies loop
	}

	protected void loadAllAgents(TRCProcessProxy processProxy)
	{
		for (Iterator agents = processProxy.getAgentProxies().iterator(); agents.hasNext();)
		{
			TRCAgentProxy trcAgent = (TRCAgentProxy) agents.next();
			if (trcAgent != null && !trcAgent.eIsProxy())
			{
				addAgent(trcAgent);
			}
		} // agent loop
	}
	
	protected void addAgent(TRCAgentProxy agent)
	{
		// if the agent is in the list already return
		if (agents.containsKey(agent))
			return;

		agents.put(agent, new Double(0));

		try
		{
			agentList[nextAgent] = agent;
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			TRCAgentProxy[] tempArray = new TRCAgentProxy[agentList.length + 16];
			System.arraycopy(agentList, 0, tempArray, 0, agentList.length);
			agentList = tempArray;
			agentList[nextAgent] = agent;
		}
		nextAgent++;

	}
	
	protected NodeContainer addLog(Object o){
		
	   if(o instanceof TRCAgentProxy){
	   	   NodeContainer nodeContainer = graph.createNodeContainer();
	   	   nodeContainer.setShortName(((TRCAgentProxy)o).getName());
	   	   graph.addTopNode(nodeContainer);
	   	   nodeContainer.setGraph(graph);
	   	   nodeContainer.setType(GraphNode.LOG);
	   	   return nodeContainer;
	   }
	   return null;	
	}
	
	
	protected String addRecords(NodeContainer nodeContainer, EList list){
		
	   
	   	  GraphNode graphNode;
	   	  Increment increment;
	   	  String hostName = "";
	   	  Hashtable userArea;
	   	  double currentTime=0;
	   	  int extraIncrements = 0;
	   	  double previousTime=0.0;
	   	  double timeDifference=0.0;
	   	  for(int i=0; i<list.size();i++){
	   	  	 if(list.get(i)!=null && list.get(i) instanceof CBECommonBaseEvent){
	   	  	 	
	   	  	 	graphNode = graph.createGraphNode();
	   	  	 		   	  	 	
	   	        graphNode.setName(((CBECommonBaseEvent)list.get(i)).getMsg());

	   	        currentTime = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)list.get(i));

	   	  	 	if(i==0)
	   	  	 	   hostName = ((CBECommonBaseEvent)list.get(i)).getSourceComponentId().getLocation();
	   	        
	   	        timeDifference = currentTime - previousTime;
	   	        if(timeDifference == 0.0){
	   	           if(graph.getIncrementList()[i+extraIncrements]==null)
	   	              graph.addIncrementAppendDup(0.0);
	   	           graphNode.setStartIncrement(graph.getIncrementList()[i+extraIncrements]);
	   	           if(graph.getIncrementList()[i+1+extraIncrements]==null)
	   	              graph.addIncrementAppendDup(0.0);
	   	           graphNode.setEndIncrement(graph.getIncrementList()[i+1+extraIncrements]);
	   	        }else if(timeDifference>0.0){
	   	           if(graph.getIncrementList()[i+extraIncrements]==null)
	   	              graph.addIncrementAppendDup(0.0);
	   	           if(graph.getIncrementList()[i+1+extraIncrements]==null)
	   	              graph.addIncrementAppendDup(timeDifference);
	   	           graphNode.setStartIncrement(graph.getIncrementList()[i+1+extraIncrements]);
	   	           if(graph.getIncrementList()[i+2+extraIncrements]==null)
	   	              graph.addIncrementAppendDup(0.0);
	   	           graphNode.setEndIncrement(graph.getIncrementList()[i+2+extraIncrements]);
	   	           previousTime = currentTime;
	   	           extraIncrements++;
	   	        }
	   	           
	   	        graphNode.setContainer(nodeContainer);
	   	        graphNode.setUserArea(list.get(i));
	   	        nodeContainer.addInternalNode(graphNode);
	   	        graphNode.setStartTime(currentTime);
	   	        graphNode.setEndTime(currentTime);
	   	        graphNode.setType(GraphNode.RECORD);
	   	  	 }
	      }
	      return hostName;
	}
	
	private void addConnections(CBECommonBaseEvent artifact,EList correlatedArtifacts){
		
		//System.out.println("TRCLogLoader.addConnections");
		GraphNode graphNode=null;
		GraphNode source=null, target=null;
		source = getGraphNodeFromArtifact(artifact);
		for(int l=0; l<correlatedArtifacts.size();l++){
		   Object ca = correlatedArtifacts.get(l);
		   if(!(ca instanceof CBECommonBaseEvent))
		   		continue;
		   target = getGraphNodeFromArtifact((CBECommonBaseEvent)correlatedArtifacts.get(l));
		   if(target != null)
		      createConnection(source,target);
		   target = null;
		}
	}
	
	private GraphNode getGraphNodeFromArtifact(CBECommonBaseEvent artifact){

		GraphNode graphNode=null;
		GraphNode source=null;
		for(int i=0; i<graph.getTopNodeCount();i++){
			for(int k=0; k<((NodeContainer)graph.getTopNodes()[i]).getInternalNodeCount();k++){
				graphNode = ((NodeContainer)graph.getTopNodes()[i]).getInternalNodes()[k];
		       if(graphNode!=null && artifact==graphNode.getUserArea()){
		       	  source = graphNode;
		          break;
		       }
			}
		}
		return source;
	}
	
	private NodeConnection createConnection(GraphNode source, GraphNode target){
		NodeConnection connection = graph.createNodeConnection();
		connection.setName(target.getName());
		connection.setShortName(target.getShortName());
		connection.setSecondaryName(target.getSecondaryName());
		connection.setTarget(target);
		connection.setSource(source);
		connection.setType(NodeConnection.CALL);
		
		// if the target start time >= connection start time, reuse the increment
		// and recover from time missmatches due to network delays etc.
		//if (target.getStartTime() >= segment.getStartElement().getElapsed_time() + deltaTime)
			connection.setEndIncrement(target.getStartIncrement());
		//else
			//connection.setEndTime(segment.getStartElement().getElapsed_time() + deltaTime);

		// in this release connection start and end times are the same  
		connection.setStartIncrement(connection.getEndIncrement());

		// if the connection start time >= source end time, reuse the increment
		// and recover from time missmatches
		if (connection.getStartTime() > source.getEndTime())
			source.setEndIncrement(connection.getStartIncrement());

		target.addTargetConnection(connection);
		source.addSourceConnection(connection);
		
		return connection;
	   	
	}
}
