/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.console;

import java.util.ResourceBundle;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.text.*;
import org.eclipse.ui.texteditor.*;

/*
* CONTEXT_ID cnva0000 for console viewer action
*/

public class ConsoleViewerAction extends TextEditorAction {

	private int fOperationCode= -1;
	private ITextOperationTarget fOperationTarget;

	public ConsoleViewerAction(ResourceBundle bundle, String prefix, TraceConsoleViewer viewer, int operationCode) {
		super(bundle, prefix, null);
		fOperationCode= operationCode;
		fOperationTarget= viewer.getTextOperationTarget();
		update();
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this,
		UIPlugin.getPluginId()+".cnva0000");
	}
	/**
	 * @see Action
	 */
	public void run() {
		if (fOperationCode != -1 && fOperationTarget != null) {
			fOperationTarget.doOperation(fOperationCode);
		}
	}
	/**
	 * @see TextEditorAction
	 */
	public void update() {

		boolean wasEnabled= isEnabled();
		boolean isEnabled= (fOperationTarget != null && fOperationTarget.canDoOperation(fOperationCode));
		setEnabled(isEnabled);

		if (wasEnabled != isEnabled) {
			firePropertyChange(ENABLED, wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
		}
	}
}
