/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID tvpp0001 for show Monitors checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0002 for show Hosts checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0003 for show Processes checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0004 for show Profiling Agents checkbox Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0005 for show JVM RAS Agents checkbox in Monitor views preference page
*/
/*
* CONTEXT_ID tvpp0006 for show Logging Agents checkbox in Monitor views preference page
*/

public class TraceViewOptionsUI
{
	private Button _showFolder;
	private Button _showMonitor;
	private Button _showNode;
	private Button _showProcess;

	private Button _showProf;
	private Button _showLog;

/**
 * TraceOptionsUI constructor comment.
 */
public TraceViewOptionsUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	
	Group content = new Group(parent, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	content.setLayout(layout);
	content.setLayoutData(GridUtil.createHorizontalFill());
	content.setText(UIPlugin.getResourceString("STR_PREF_SHOW_GRP"));

	_showFolder = new Button(content, SWT.CHECK);
	_showFolder.setText(UIPlugin.getResourceString("STR_TOOL_BAR_FOLDER"));

	_showMonitor = new Button(content, SWT.CHECK);
	_showMonitor.setText(UIPlugin.getResourceString("STR_PREF_SHOW_MON"));
	
	_showNode = new Button(content, SWT.CHECK);
	_showNode.setText(UIPlugin.getResourceString("STR_PREF_SHOW_NODE"));
	
	_showProcess = new Button(content, SWT.CHECK);
	_showProcess.setText(UIPlugin.getResourceString("STR_PREF_SHOW_PROC"));

	_showProf = new Button(content, SWT.CHECK);
	_showProf.setText(UIPlugin.getResourceString("STR_PREF_SHOW_PROF"));
		
	_showLog = new Button(content, SWT.CHECK);
	_showLog.setText(UIPlugin.getResourceString("STR_PREF_SHOW_LOG"));

	initializeValues();     
/*
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showMonitor,
		UIPlugin.getPluginId()+".tvpp0001");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showNode,
		UIPlugin.getPluginId()+".tvpp0002");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showProcess,
		UIPlugin.getPluginId()+".tvpp0003");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showProf,
		UIPlugin.getPluginId()+".tvpp0004");

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_showLog,
			UIPlugin.getPluginId()+".tvpp0006");
*/		
	return content; 
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:04:12 AM)
 * @return boolean
 */
public boolean getShowLog() {
	return _showLog.getSelection();
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:04:12 AM)
 * @return boolean
 */
public boolean getShowFolder() {
	return _showFolder.getSelection();
}

public boolean getShowMonitor() {
	return _showMonitor.getSelection();
}

/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:04:12 AM)
 * @return boolean
 */
public boolean getShowNode() {
	return _showNode.getSelection();
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:04:12 AM)
 * @return boolean
 */
public boolean getShowProcess() {
	return _showProcess.getSelection();
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:04:12 AM)
 * @return boolean
 */
public boolean getShowProf() {
	return _showProf.getSelection();
}
/**
 * Initializes states of the controls from the preference store.
 */
private void initializeValues()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

	_showFolder.setSelection(store.getBoolean(TraceConstants.SHOW_FOLDER_KEY));
	_showMonitor.setSelection(store.getBoolean(TraceConstants.SHOW_MON_KEY));
	_showNode.setSelection(store.getBoolean(TraceConstants.SHOW_NODE_KEY));
	_showProcess.setSelection(store.getBoolean(TraceConstants.SHOW_PROCESS_KEY));
	
	_showLog.setSelection(store.getBoolean(TraceConstants.SHOW_LOG_KEY));	
	_showProf.setSelection(store.getBoolean(TraceConstants.SHOW_PROF_KEY));	
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:02:27 AM)
 * @param option boolean
 */
public void setShowLog(boolean option)
{
	_showLog.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:02:27 AM)
 * @param option boolean
 */
public void setShowMon(boolean option) {}

/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:02:27 AM)
 * @param option boolean
 */
public void setShowFolder(boolean option)
{
	_showFolder.setSelection(option);
}

/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:02:27 AM)
 * @param option boolean
 */
public void setShowMonitor(boolean option)
{
	_showMonitor.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:02:27 AM)
 * @param option boolean
 */
public void setShowNode(boolean option)
{
	_showNode.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:02:27 AM)
 * @param option boolean
 */
public void setShowProcess(boolean option)
{
	_showProcess.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 11:02:27 AM)
 * @param option boolean
 */
public void setShowProf(boolean option)
{
	_showProf.setSelection(option);
}
}
