/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.hyades.trace.ui.internal.wizard.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.window.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.ui.*;

public class AttachRemoteAction extends Action implements IWorkbenchWindowActionDelegate
{
	public AttachRemoteAction()
	{
		super(UIPlugin.getResourceString("REMOTE_PROCESS"));//, PDPluginImages.getImageDescriptor(PDPluginImages.IMG_ACT_ATTACH));
		PDPluginImages.setImageDescriptors(this,PDPluginImages.T_TOOL,PDPluginImages.IMG_ACT_ATTACH);
	}
	public void dispose() {
		// do nothing.
	}
	public void init(IWorkbenchWindow window) {
		// do nothing.
	}
	public void run()
	{
		org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
			public void run() {
				final IWorkbenchWindow window= UIPlugin.getActiveWorkbenchWindow();		
				AttachRemoteWizard wizard = new AttachRemoteWizard();
				WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
				int result = dialog.open();
				
				IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
							
				if (result == Window.OK && store.getBoolean(TraceConstants.PROFILE_TIPS)) {				
				AttachInfoDialog infodialog =
					new AttachInfoDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("PROFILING_TIP_TITLE"));
				infodialog.open();	
				}
			}
		});				
	}
	//---- IWorkbenchWindowActionDelegate ------------------------------------------------

	public void run(IAction action) {
		run();
	}
	public void selectionChanged(IAction action, ISelection selection) {
		// do nothing. Action doesn't depend on selection.
	}
}
