/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.wizard.WizardPage;

/**
*
*/
public class DoubleCTree
{
  Composite _group;
  Composite groupWidget;  


  public    CTree     sourceList;
  public    CTree     targetList;
  private   CTree     selectedList;
  public    Label     targetListLabel;
  public    Label     sourceListLabel;


  public  Button    add;
  public  Button    remove;
  public  Button    addAll;
  public  Button    removeAll;
  public  Vector    agentSelected;


  private WizardPage _wizardPage;


  class TreeSelListener implements SelectionListener
  {
	public void widgetSelected(SelectionEvent e)  
	{
		
	  //allow only one list to have selection 
	  if(e.widget == sourceList.getTree() && sourceList.getTree().getSelection().length != 0)
		targetList.clearSelection();                          
	  else if(e.widget == targetList.getTree() && targetList.getTree().getSelection().length != 0)
		sourceList.clearSelection();
		
	}
	public void widgetDefaultSelected(SelectionEvent e)  
	{
	   if(e.widget == sourceList.getTree())
	   {
		 TreeItem[] items = sourceList.getSelectedItems();
		 if(items.length > 0)
		 {
		   for(int idx=0; idx<items.length; idx++)
		   {
		   	   
		   	   addAgentToSelectList(items[idx]);
			   targetList.addItem(items[idx], true);               
			   sourceList.remove(items[idx]);             
			   sourceList.clearSelection();                                        
		   } 
		 }
	   }
	   else if(e.widget == targetList.getTree())
	   {
		 TreeItem[] items = targetList.getSelectedItems();
		 if(items.length > 0)
		 {
		   for(int idx=0; idx<items.length; idx++)
		   {
	           removeAgentFromSelectList(items[idx]);    
			   sourceList.addItem(items[idx], false);               
			   targetList.remove(items[idx]);             
			   targetList.clearSelection();
		   }
		 }
	   } 
    }
  }


  
  class ButtonListener implements Listener
  {
	public void handleEvent (Event e)
	{
		if(e.widget == add)
		{
		  targetList.getTree().setRedraw(false);
		  sourceList.getTree().setRedraw(false);
		  
		  TreeItem[] items= sourceList.getSelectedItems();
		  for (int i = 0; i < items.length; i++)
		  {
		  	if (!vaildItemtoAdd(items[i])) continue;
			addAgentToSelectList(items[i]);
			targetList.addItem(items[i], true);
			sourceList.remove(items[i]);		
		  }        
		  sourceList.clearSelection();
		  if ((_wizardPage!=null) && (agentSelected.size() > 0))
		  	_wizardPage.setPageComplete(true);

		  targetList.getTree().setRedraw(true);
		  sourceList.getTree().setRedraw(true);
		  
		}
		else if(e.widget == addAll)
		{
		  targetList.getTree().setRedraw(false);
		  sourceList.getTree().setRedraw(false);

		  for (int i=0; i < sourceList.getTree().getItemCount(); i++)
		  {
			 TreeItem item = sourceList.getItem(i);
			 if (!vaildItemtoAdd(item)) continue;
			 addAgentToSelectList(item);
			 targetList.addItem(item, false);
		  }        

		  sourceList.getTree().removeAll();
		  targetList.getTree().selectAll();
		  
		  if ((_wizardPage!=null) && (agentSelected.size() > 0))
		  	_wizardPage.setPageComplete(true);


		  targetList.getTree().setRedraw(true);
		  sourceList.getTree().setRedraw(true);       
		  
		}
		else if(e.widget == remove)
		{
		  targetList.getTree().setRedraw(false);
		  sourceList.getTree().setRedraw(false);
			
		  TreeItem[] items = targetList.getSelectedItems();
		  for (int i = 0; i < items.length; i++)
		  {
		  	removeAgentFromSelectList(items[i]);    
			sourceList.addItem(items[i], false);
			targetList.remove(items[i]);
		  }        
		 targetList.clearSelection();
		 
		 if ((agentSelected.size()==0) && (_wizardPage!=null))
		 	_wizardPage.setPageComplete(false);


		  targetList.getTree().setRedraw(true);
		  sourceList.getTree().setRedraw(true);      
		}
		else if(e.widget == removeAll)
		{
		  targetList.getTree().setRedraw(false);
		  sourceList.getTree().setRedraw(false);            
		  for (int i=0; i < targetList.getTree().getItemCount(); i++)
		  {
			 TreeItem item = targetList.getItem(i);
			 removeAgentFromSelectList(item);    
			 sourceList.addItem(item, false);
		  }
		  
		  targetList.getTree().removeAll();
		  if (_wizardPage!=null)
		  _wizardPage.setPageComplete(false);
		  
		  targetList.getTree().setRedraw(true);       
		  sourceList.getTree().setRedraw(true);       
		  
		}
	}
  }

 public void addAgentToSelectList(TreeItem item)
 {
  	if (item.getParentItem() != null)
	{
		/*agent selected*/
		addAgentSelected(item);
	}
	else
	{
		/*process selected*/
		TreeItem[] agentItems = item.getItems();
		for (int k=0; k<agentItems.length; k++)
		{
			addAgentSelected(agentItems[k]);
		}
	}
 }
 
 public void removeAgentFromSelectList(TreeItem item)
 {
	if (item.getParentItem() != null)
	{
		/*agent selected */
		removeAgentSelected(item);
	}
	else
	{
		/*process selected */
		TreeItem[] agentItems = item.getItems();
		for (int k=0; k<agentItems.length; k++)
		{
			removeAgentSelected(agentItems[k]);
		}
	}
 }
 private boolean vaildItemtoAdd(TreeItem item)
 {
 	if (item.isDisposed() || item==null || ((item.getParentItem()!=null) && (item.getParentItem().isDisposed()))) return false;
 	else
 	return true;
 }

 public void addAgentSelected(TreeItem item)
 {
	Agent a = (Agent)(item.getData());
	if (!agentSelected.contains(a))
		agentSelected.add(a);
 }


public void removeAgentSelected(TreeItem item)
 {
	Agent a = (Agent)(item.getData());
	if (agentSelected.contains(a))
		agentSelected.remove(a);
 }


  public void setWizardPage(WizardPage wizardPage)
  {
  	_wizardPage = wizardPage;
  }
  




  public DoubleCTree(Composite parent, int style, String groupText,
					 String sourceTextID, String targetTextID)
  {
	agentSelected=new Vector();
	//_group = new Group(parent, style);
	_group = new Composite(parent, style);
	//_group.setText(groupText);
	
	GridLayout layout= new GridLayout();
	layout.verticalSpacing= -10;
	layout.horizontalSpacing= 0;    
	_group.setLayout(layout);
	_group.setLayoutData(GridUtil.createFill());
	
	createDoubleTree(_group, sourceTextID, targetTextID);


	//add listeners
	add.addListener(SWT.Selection, new ButtonListener());
	remove.addListener(SWT.Selection, new ButtonListener());
	addAll.addListener(SWT.Selection, new ButtonListener());
	removeAll.addListener(SWT.Selection, new ButtonListener());
	//double-click action
	sourceList.getTree().addSelectionListener(new TreeSelListener());
	targetList.getTree().addSelectionListener(new TreeSelListener());
	///////////////////
  }  
  
  /**
  * Create double list components
  */
  public void createDoubleTree(Composite parent, 
					 String sourceTextID, String targetTextID)    
  {
	  GridData spec;
	  
	// Create the grid.
	groupWidget = parent;


	GridLayout layout = new GridLayout();
	layout.numColumns = 3;
	groupWidget.setLayout(layout);


	sourceList = new CTree(groupWidget, sourceTextID);  
	sourceList.getTree().setLayoutData(GridUtil.createFill());  
	
	// Create the grid. 
	Composite buttonWidget = new Composite (groupWidget, SWT.NULL);   
	GridLayout blayout = new GridLayout();
	blayout.numColumns = 1;
	buttonWidget.setLayout(blayout);     
	
	Label label = new Label (buttonWidget, SWT.PUSH);
	label.setText("");
	spec = new GridData();
	spec.grabExcessVerticalSpace = true;
	spec.verticalAlignment = GridData.FILL;
	label.setLayoutData(spec);
	
	add = new Button(buttonWidget, SWT.PUSH);
	add.setText(UIPlugin.getResourceString("LEFT_TO_RIGHT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	add.setLayoutData(spec);


	remove = new Button(buttonWidget, SWT.PUSH);
	remove.setText(UIPlugin.getResourceString("RIGHT_TO_LEFT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	remove.setLayoutData(spec);
	
	new Label(buttonWidget, SWT.NONE);

	addAll = new Button(buttonWidget, SWT.PUSH);
	addAll.setText(UIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	addAll.setLayoutData(spec);
		
	removeAll = new Button(buttonWidget, SWT.PUSH);
	removeAll.setText(UIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	removeAll.setLayoutData(spec);


	Label label1 = new Label (buttonWidget, SWT.PUSH);
	label1.setText("");
	spec = new GridData();
	spec.grabExcessVerticalSpace = true;
	spec.verticalAlignment = GridData.FILL;
	label.setLayoutData(spec);
			
	targetList = new CTree(groupWidget, targetTextID);
	targetList.getTree().setLayoutData(GridUtil.createFill());          
  }  
/**
 * Insert the method's description here.
 * Creation date: (10/31/2000 3:10:43 PM)
 * @param enable boolean
 */
public void enable(boolean enable)
{
	_group.setEnabled(enable);
	add.setEnabled(enable);
	addAll.setEnabled(enable);
	remove.setEnabled(enable);
	removeAll.setEnabled(enable);


	sourceList.enable(enable);
	targetList.enable(enable);
}
/**
 * Insert the method's description here.
 * Creation date: (11/08/2000 2:31:59 PM)
 * @return com.ibm.swt.widgets.Control
 */
public Control getControl() {
	return _group;
}/**
 * Insert the method's description here.
 * Creation date: (11/01/2000 2:59:50 PM)
 * @param nodes com.ibm.etools.perftrace.TRCNode[]
 */ 
  private Vector getItems(CTree list)
  {
	 Vector items = new Vector();
	 for (int i=0; i<list.getTree().getItemCount(); i++)
	 {
		Object item = list.getItem(i);
		if(item != null)
			items.addElement(item);
	 }      
	 return items;
  }
   
  public Vector getSelectedAgents()
  {
  	return agentSelected;
  }  
  public Vector getSourceItems()
  {
	return getItems(sourceList);
  }  
  public Vector getTargetItems()
  {
	return getItems(targetList);
  }  
  public String getText()
  {
	return getTargetItems().toString();
  }  
  public Composite getWidget()
  {
	  return groupWidget;
  }  
 
 
public void initialize(Enumeration processes, boolean showAll)
{
	initialize(processes, showAll, false);
}
  
public void initialize(Enumeration processes, boolean showAll, boolean showAttached)
{
	if (processes==null)
	{
		sourceList.initializeTree(null, showAll, showAttached);
		targetList.initializeTree(null, showAll, showAttached);  
	}
	else if (targetList.getItemCount() == 0)
	{	
		sourceList.initializeTree(processes, showAll, showAttached);
		targetList.initializeTree(null, showAll, showAttached);  
	}
	else
	{
		//EC: refresh button was clicked with selected agent(s)
		//EC: this need special care as refresh button shouldn't 'reset' the 2 list, but update it instead.
				
		Vector allPIDList = new Vector();
	
		while (processes.hasMoreElements())
		{
			Process process = (Process) processes.nextElement();       
			Enumeration agents = process.listAgents();
			
			String pid = null;
			try {
				pid = process.getProcessId();
				allPIDList.add(pid);
			}
			catch (Exception e)
			{
				System.out.println("null pid");
			}
			
			TreeItem sourceItem = getItemFromTree(sourceList,process);
			TreeItem targetItem = getItemFromTree(targetList,process);
			
			if (sourceItem != null)
			{
				if (targetItem != null)
				{
					// process exists in both target and source.
					while (agents.hasMoreElements())
					{
						Agent agent = (Agent)agents.nextElement();
						TreeItem agentItem = getAgentItem(targetItem,agent);
						if (agentItem == null)
						{
							agentItem = getAgentItem(sourceItem,agent);
							if (agentItem == null)
							{
								//agent not in any list, add to source list.
								createItemInSourceList(sourceItem,agent, showAttached);
							}
						}
					}
					//remove agents in list that is not exist anymore
					removeAgentsInLists(process,targetItem,sourceItem);
				}
				else
				{
					// process exists in source only.
					while (agents.hasMoreElements())
					{
						Agent agent = (Agent)agents.nextElement();
						TreeItem agentItem = getAgentItem(sourceItem,agent);
						if (agentItem == null)
						{
							//agent not in any list, add to source list.
							createItemInSourceList(sourceItem,agent, showAttached);
						}
					}
					//remove agents in list that is not exist anymore
					removeAgentsInLists(process,targetItem,sourceItem);
				}
			}
			else if (targetItem != null)
			{
				// process exists in target only.
				TreeItem processItem = null;
				while (agents.hasMoreElements())
				{
					Agent agent = (Agent)agents.nextElement();
					TreeItem agentItem = getAgentItem(targetItem,agent);
					if (agentItem == null)
					{
						//agent not in any list, add to source list.
						if (processItem == null)
							processItem = sourceList.createItem(null,process,false);
						createItemInSourceList(processItem,agent, showAttached);
					}
				}
				//remove agents in list that is not exist anymore
				removeAgentsInLists(process,targetItem,sourceItem);
			}
			else
			{
				//new process and add to source list
				sourceList.addProcessToTree(process,showAll, showAttached);				
			}
		}
		//remove process that not exists anymore	
		cleanUpSourceList(allPIDList);
		cleanUpTargetList(allPIDList);
	}
}


  private void removeAgentsInLists(Process process,TreeItem targetItem,TreeItem sourceItem)
  {
  	Agent agent=null;
	if (targetItem != null)
 	{
 		TreeItem[] agentItems = targetItem.getItems();
 		int agentItemsSize = agentItems.length;
 		for (int i=0;i<agentItemsSize;i++)
 		{
  				agent = findAgentInProcess(process,agentItems[i].getText());
  				if (agent == null)
  				{
  					targetList.remove(agentItems[i]);
  					removeAgentFromSelectList(agentItems[i]);
  				}
 		}
   	}
  	if (sourceItem != null)
  	{
  		TreeItem[] agentItems = sourceItem.getItems();
 		int agentItemsSize = agentItems.length;
 		for (int i=0;i<agentItemsSize;i++)
 		{
  				agent = findAgentInProcess(process,agentItems[i].getText());
  				if (agent == null)
  				{
  					sourceList.remove(agentItems[i]);
  					removeAgentFromSelectList(agentItems[i]);
  				}
 		}
  		
  	}
  }
  
  public Agent findAgentInProcess(Process process,String agentName)
  {
  	Enumeration agents = process.listAgents();
  	Agent agent=null;
  	while (agents.hasMoreElements())
  	{
  		agent = (Agent)agents.nextElement();
  		if ((agent.getName()).equals(agentName))
  			return agent;
   	}
  	return null;
  }
  
  private void createItemInSourceList(TreeItem sourceItem,Agent agent, boolean showAttached)
  {
  		boolean logAgentsEnabled=UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.LOG_OPTION_KEY);
		boolean profileAgentsEnabled=UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY);
		if(agent.isActive() && (showAttached || !agent.isAttached())) {
			if(logAgentsEnabled && agent.getType().equals(TraceConstants.LOG_AGENT_TYPE)) {
			 	sourceList.createItem(sourceItem, agent, false);
			}
			else if(profileAgentsEnabled && agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
			 	sourceList.createItem(sourceItem, agent, false);
			}
			else
			{
				ArrayList agentList = sourceList.getAgentTypeList();
				for (int i=0;i<agentList.size();i++)
				if (!(agent.getType().equals(TraceConstants.LOG_AGENT_TYPE))
				 && (agent.getType().equals((String)(agentList.get(i)))))	
					sourceList.createItem(sourceItem, agent, false);	
			}
		}
  }
    
  public TreeItem getAgentItem(TreeItem treeItem, Agent agent)
  {
  		TreeItem[] agentItems = treeItem.getItems();
  		for (int i=0;i<agentItems.length;i++)
  		{
  			if (agentItems[i].getText().equals(agent.getName()))
  			return agentItems[i];
  		}
  	 	return null;
  }

  public TreeItem getItemFromTree(CTree tree, Object obj)
  {
  	 for (int i=0; i<tree.getTree().getItemCount(); i++)
	 {
	 	try {
			TreeItem item = tree.getItem(i);
			if (parseProcessID(item.getText()).equals(((Process)obj).getProcessId()) ) 
			   return item;
	 	}
		catch (Exception e)
		{
			System.out.println("null pid");
		}
	 }
	 return null;
  }

  private String parseProcessID(String text)
  {
  	if (text==null) return null;
  	
  	int sIdx = text.indexOf(":");
  	int eIdx = text.indexOf("]");
  	String pid = text.substring(sIdx+1,eIdx);
  	//System.out.println(pid);
  	return pid;
  }
  
  private void cleanUpSourceList(Vector pidList)
  {
    TreeItem[] items = sourceList.getTree().getItems();
    Vector v = new Vector();
    for (int i=0;i<items.length;i++)
    {
    	if (!(pidList.contains(parseProcessID(items[i].getText()))))
    	{
    		v.add(items[i]);
    		removeAgentFromSelectList(items[i]);
	   	}
    }
    removeFromTree(sourceList,v);
  }

  private void cleanUpTargetList(Vector pidList)
  {
  	TreeItem[] items = targetList.getTree().getItems();
  	Vector v = new Vector();
    for (int i=0;i<items.length;i++)
    {
    	if (!(pidList.contains(parseProcessID(items[i].getText()))))
    	{
     		v.add(items[i]);
     		removeAgentFromSelectList(items[i]);
    	}
    }
     removeFromTree(targetList,v);
  }

  private void removeFromTree(CTree tree,Vector v)
  {
  	for (int i=0;i<v.size();i++)
  	{
  		tree.remove((TreeItem)(v.elementAt(i)));
  	}
  }
  
  public void removeAll()
  {
	  targetList.getTree().removeAll();
	  sourceList.getTree().removeAll(); 
  }  
  public void setEnabled(boolean b)
  {
	  targetList.getTree().setEnabled(b);
	  sourceList.getTree().setEnabled(b);     
  }  
  public void setToolTipText(String text)
  {
	 sourceList.setToolTipText(text);
	 targetList.setToolTipText(text);    
  }  
}
