/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
/*
* CONTEXT_ID pcwp0000 for profile collections wizard page
*/
public class AgentCollectionsPage extends WizardPage {
	protected TraceProfileCollectionsUI _optionsUI;
	protected String _type;

	public AgentCollectionsPage(String name, String type) {
		super(name);
		_type = type;
		setTitle(UIPlugin.getResourceString("AGENT_LIMIT_WIZARD_TITLE"));
		setDescription(UIPlugin.getResourceString("AGENT_LIMIT_WIZARD_DESCR"));
	}
	public void createControl(Composite parent) {
		Label label;

		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 5;
		content.setLayout(layout);
		GridData gd = GridUtil.createFill();
		gd.widthHint = 500;
		gd.heightHint = 400;
		content.setLayoutData(gd);

		_optionsUI = new TraceProfileCollectionsUI();
		_optionsUI.createControl(content);
		_optionsUI.setWizardPage(this);

		setControl(content);

		initializeValues();

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			UIPlugin.getPluginId() + ".pcwp0000");
	}
	public boolean finish() {
		
		_optionsUI.storeValues();
		return true;

	}

	public Vector getOptions() {
		return _optionsUI.getOptions();
	}

	private void initializeValues() {
		_optionsUI.enableButtons();

		if (getWizard() instanceof LaunchLocalWizard
			|| getWizard() instanceof LaunchRemoteWizard
			|| getWizard() instanceof RelaunchWizard) {
			_optionsUI.enableMonitoringSlectionGroup(true);
		}

		if (getWizard() instanceof RelaunchWizard) {
			((RelaunchWizard) getWizard()).setAgentOptions();
		}

	}
	public void initializeValues(EList options) {

		if (options != null) {
			Iterator i = options.iterator();
			while (i.hasNext()) {
				TRCOption option = (TRCOption) i.next();

				if (option.getKey().equals(Options.OPTION_BURST_MODE)) {
						if (option
							.getValue()
							.equals(
								Options.OPTION_VALUE_SECONDSANDINVOCATIONS)) {
							_optionsUI.setLimitInvocations(true);
							_optionsUI.setLimitTime(true);
						} else if (
							option.getValue().equals(
								Options.OPTION_VALUE_INVOCATIONS)) {
							_optionsUI.setLimitInvocations(true);
							_optionsUI.setLimitTime(false);

						} else if (
							option.getValue().equals(
								Options.OPTION_VALUE_SECONDS)) {
							_optionsUI.setLimitInvocations(false);
							_optionsUI.setLimitTime(true);
						}

				} else if (option.getKey().equals(Options.OPTION_BURST_INVOCATIONS)) {
							_optionsUI.setLimitInvocNb(option.getValue());
				} else if (option.getKey().equals(Options.OPTION_BURST_SECONDS)) {
							_optionsUI.setLimitTimeNb(option.getValue());
				}
			}
		}
	}

	/**
	 * Determine whether this page should be enabled.
	 */
	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if (visible) {
			Vector aList = getAgentsList();
			if (aList != null && !hasProfilingAgent(aList)) {
				this.getControl().setEnabled(false);
				this.getControl().setVisible(false);
				this.setDescription(
					UIPlugin.getResourceString("STR_LIMIT_IGNORED"));

			} else {
				this.getControl().setEnabled(true);
				this.getControl().setVisible(true);
				this.setDescription(
					UIPlugin.getResourceString("AGENT_LIMIT_WIZARD_DESCR"));
			}
		}
	}
	/**
	 * Get the list of agents depending on the type of wizard.
	 */
	private Vector getAgentsList() {
		DoubleCTree agentList = null;
		Vector aList = null;

		if (_type.equals(TraceConstants.ATTACH_LOCAL_WIZARD)) {
			agentList = ((AttachLocalWizard) getWizard()).getAgentList();
		} else if (_type.equals(TraceConstants.ATTACH_REMOTE_WIZARD)) {
			agentList = ((AttachRemoteWizard) getWizard()).getAgentList();
		}

		if (agentList != null) {
			aList = agentList.getSelectedAgents();
		}

		return aList;
	}
	/**
	 * Return true if have at least one Profiling Agent.
	 */
	private boolean hasProfilingAgent(Vector agents) {
		for (int idx = 0; idx < agents.size(); idx++) {
			Agent agent = (Agent) agents.elementAt(idx);
			if (agent.getType() != null
				&& agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)
				&& !agent.getName().equals(TraceConstants.J2EE_AGENT_NAME)) {
				return true;
			}
		}
		return false;
	}
	
	public boolean getAutoMonitoring(){
		return _optionsUI.getAutoMonitoring();
	}
	public void setAutoMonitoring(boolean autoMonitoring){
		_optionsUI.setAutoMonitoring(autoMonitoring);
	}
	
	
}
