/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

/*
* CONTEXT_ID lrht0000 for launch remote host page
*/
public class HostDataPage  extends WizardPage				 
{
	private TraceHostUI _hostUI;
	
public HostDataPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("HOSTDATAPAGE_TITLE"));
	setDescription(UIPlugin.getResourceString("HOSTDATAPAGE_DESP"));
	setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_NEWNODE));
  }  
  public void createControl(Composite parent)
  {
	_hostUI = new TraceHostUI(this);
	setControl(_hostUI.createControl(parent));
	
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".lrht0000");

		setPageComplete(_hostUI.getHost() != null);
  }    
  public boolean finish()  
  {
	  storeValues();
	
	  return true;
  }  
 /**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */
 
public void setPageComplete(boolean complete)
{
	super.setPageComplete(complete);
}

public String getHost() {
	return _hostUI.getHost();
}/**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */ 
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 5:19:46 PM)
 * @return java.lang.String
 */
public String getNodeName() {
	return _hostUI.getHost();
}

public int getPortNumber() {
	return _hostUI.getPort();
}

/**
 * Stores the values of the controls back to the preference store.
 */
private void storeValues()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore(); 

	String hosts = "";
	
	TableItem[] items = _hostUI.getHosts();
	for(int idx=0; idx<items.length; idx++)
	{
		hosts +=","+items[idx].getText().trim();		
	}

	if(hosts.startsWith(",") && hosts.length() > 1)
	  hosts = hosts.substring(1);

	store.setValue(HyadesConstants.HOST_KEY, hosts);
}

}
