/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class LaunchRemoteWizard
	extends Wizard
	implements INewWizard, IRunnableWithProgress {
	private HostDataPage fHostPage;
	private ProcessRemoteDataPage fProcessPage;
	private DestinationFolderPage fFolderPage;
	private ProfileOptionsPage fProfilePage;
	private AgentOptionsPage fOptionsPage;
	private AgentCollectionsPage fCollectionsPage;	
	private IStatus error;
	private boolean fShowHostPage;
	private String fNodeName;
	private int fPortNumber;
	private boolean success;
	private boolean isProfilingEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY);
	
	public LaunchRemoteWizard() {
		this(true, "", "10002");
	}
	public LaunchRemoteWizard(
		boolean showHostPage,
		String nodeName,
		String portNumber) {
		super();
		setNeedsProgressMonitor(true);
		fShowHostPage = showHostPage;
		fNodeName = nodeName;
		fPortNumber = Integer.parseInt(portNumber);
	}
	public void addPages() {
		setWindowTitle(UIPlugin.getResourceString("LAUNCH_RJAVA_APP_TITLE"));
		if (fShowHostPage)
			fHostPage = new HostDataPage("hostData");
		fProcessPage = new ProcessRemoteDataPage("processData");
		fFolderPage = new DestinationFolderPage("folderPage");

		if (fShowHostPage)
			addPage(fHostPage);
		addPage(fProcessPage);
		addPage(fFolderPage);
		
		if(isProfilingEnabled)
		{
			fProfilePage = new ProfileOptionsPage("profilePage", TraceConstants.LAUNCH_REMOTE_WIZARD);
			fOptionsPage = new AgentOptionsPage("agentPage", TraceConstants.LAUNCH_REMOTE_WIZARD);
			fCollectionsPage = new AgentCollectionsPage("collentionsPage",TraceConstants.LAUNCH_LOCAL_WIZARD);
			
			addPage(fProfilePage);
			addPage(fOptionsPage);
			addPage(fCollectionsPage);
			
			fProfilePage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			fOptionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			fCollectionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));			
			
		}


		if (fShowHostPage)
			fHostPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));

		fFolderPage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 12:58:14 PM)
	 * @return java.util.Vector
	 */
	public ArrayList getFilterSet() {
		return fProfilePage.getFilterSet();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/9/2001 1:36:51 PM)
	 * @return java.lang.String
	 */
	public String getHostName() {
		if (fShowHostPage)
			return fHostPage.getHost();

		return fNodeName;
	}

	public int getPortNumber() {
		if (fShowHostPage)
			return fHostPage.getPortNumber();

		return fPortNumber;
	}
	
	public boolean getAutoMonitoring(){
		return fCollectionsPage.getAutoMonitoring();
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 10:30:42 AM)
	 * @return java.util.Vector
	 */
	public Vector getOptions() {
		
		if(isProfilingEnabled)
		{
			Vector options = fOptionsPage.getOptions();
			Vector collections = fCollectionsPage.getOptions();
			
			options.addAll(collections); 			
			return options;			
		} 
		
		return new Vector();
		
	}
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setDefaultPageImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_MON_PROP));

	}
	public boolean performFinish() {
		
		if (!fFolderPage.getFile().equals("") && !PDCoreUtil.isPathExists(fFolderPage.getFile()))
		{
			if (!PDCoreUtil.createDirectoryMessage(fFolderPage.getFile(),getShell()))
				return false;
		}
		
		
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(this);
		try {
			getContainer().run(false, true, op);
		} catch (java.lang.reflect.InvocationTargetException e) {
			MessageDialog.openError(
				getShell(),
				"Error",
				e.getTargetException().getMessage());
			return false;
		} catch (InterruptedException e) {
			return false;
		}

		return success;
	}
	public void run(IProgressMonitor mon) {
		
	   if(isProfilingEnabled)
	   {	
	       fOptionsPage.finish();	   
	       fProfilePage.finish();
	       fCollectionsPage.finish();
	   }
		
		if (fShowHostPage)
			fHostPage.finish();

		success = fFolderPage.finish();
         
		if (success)
		{
			
			success =
				fProcessPage.finish(
					fFolderPage.getProject(),
					fFolderPage.getMonitor(),
					fFolderPage.getFile());
		}
		
		if (!success) {
			error =
				new Status(
					Status.ERROR,
					UIPlugin.getPluginId(),
					IResourceStatus.INTERNAL_ERROR,
					UIPlugin.getResourceString("ERROR_CREATING_ERROR_"),
					new Exception());
		}

	}
	
	public boolean isProfilingEnabled()
	{
		return isProfilingEnabled;
	}
}
