/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.IJavaElementSearchConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
* CONTEXT_ID pldp0002 for process local data page
*/
/*
* CONTEXT_ID pldp0000 for workbench button in process local data page
*/
/*
* CONTEXT_ID pldp0001 for system button in process local data page
*/

public class ProcessLocalDataPage  extends WizardPage
							  implements SelectionListener
										 , ModifyListener
{
	private LaunchProcessUI _processUI;
	private Button          _workbenchBtn;
	private Button          _systemBtn;
	private HashMap         _classArgs = new HashMap();
	private IType           _oldSelection;
	
	private String          _selectedProject;
	private String	         _selectedMonitor;
	private String          _profileFile;
	
	private Text 			 fProjText;
	private Button			 fProjButton;
	private Text			 fMainText;
	private Button			 fSearchButton;
	
	class ArgumentData
	{
		protected String _classpath="";
		protected String _param = "";
		protected String _vmArgs = "";
		
		public ArgumentData(String classpath, String param, String vmArgs)
		{
			_classpath = classpath;
			_param = param;
			_vmArgs = vmArgs;
		}

		public String getClasspath() { return _classpath; }
		public String getParams()    { return _param; }
		public String getVMArgs()    { return _vmArgs; }
	}
	
public ProcessLocalDataPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("PROCESS_WIZARD_TITLE"));

	String desc = UIPlugin.getResourceString("PROCESSLOCALDATAPAGE_DESC");
	setDescription(desc);
	setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
	
  }
  public void createControl(Composite parent)
  {
	GridLayout layout;
	
	Composite btnGroup = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=0;
	btnGroup.setLayout(layout);
	btnGroup.setLayoutData(GridUtil.createFill());

	Label _classDetail = new Label(btnGroup, SWT.NONE);
	_classDetail.setText(UIPlugin.getResourceString("STR_CLASS_GROUP_TEXT"));

	Composite classGroup = new Composite(btnGroup, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=0;
	classGroup.setLayout(layout);
	GridData gd = GridUtil.createFill();
	gd.horizontalIndent = 20;
	classGroup.setLayoutData(gd);
	
	_workbenchBtn = new Button(classGroup, SWT.RADIO);
	_workbenchBtn.setText(UIPlugin.getResourceString("PROCESSLOCALDATAPAGE_WB_BTN_TEXT"));

	Composite wGroup = new Composite(classGroup, SWT.NONE);
	GridLayout l= new GridLayout();
	l.numColumns= 1;
	l.makeColumnsEqualWidth= true;
	l.marginWidth = 20;
	layout.verticalSpacing=0;       	
	wGroup.setLayout(l);
	wGroup.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
	
	createElementsFinderGroup(wGroup);
	
	_systemBtn = new Button(classGroup, SWT.RADIO);
	_systemBtn.setText(UIPlugin.getResourceString("PROCESSLOCALDATAPAGE_SYS_BTN_TEXT"));
	
	Composite pGroup = new Composite(classGroup, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.marginWidth = 10;
	layout.verticalSpacing=0;       	
	pGroup.setLayout(layout);
	pGroup.setLayoutData(GridUtil.createHorizontalFill());

	_processUI = new LaunchProcessUI();
	Composite systemControl = _processUI.createClassControl(pGroup);

	Label label = new Label(btnGroup, SWT.NONE);
	label.setText(UIPlugin.getResourceString("STR_ARGU_GROUP_TEXT"));

	Composite argGroup = new Composite(btnGroup,  SWT.CENTER | SWT.PUSH);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=0;
	argGroup.setLayout(layout);
	gd = GridUtil.createFill();
	gd.horizontalIndent = 20;
	argGroup.setLayoutData(gd);
		
	_processUI.createArgumentsControl(argGroup);
	_processUI.setShell(getShell());
			
	_workbenchBtn.setSelection(true);
	
	enableWorkbench(true);

	_workbenchBtn.addSelectionListener(this);
	_systemBtn.addSelectionListener(this);
	_processUI.getClassUI().addModifyListener(this);

	setPageComplete(false);
	
	setControl(btnGroup);
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_workbenchBtn,
		UIPlugin.getPluginId()+".pldp0000");
		/*
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_systemBtn,
		UIPlugin.getPluginId()+".pldp0001");	
 	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".pldp0002");	
 	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_processUI.getBrowseDirButton(),
		UIPlugin.getPluginId()+".pldp0002");	
		*/	
  }
  
  public void createElementsFinderGroup(Composite root) {
  	Composite wrkbenComp = new Composite(root, SWT.NONE);
		GridLayout projLayout = new GridLayout();
		projLayout.numColumns = 3;
		projLayout.marginHeight = 0;
		projLayout.marginWidth = 0;
		wrkbenComp.setLayout(projLayout);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		wrkbenComp.setLayoutData(gd);
		
		Label fProjLabel = new Label(wrkbenComp, SWT.NONE);
		fProjLabel.setText(UIPlugin.getResourceString("STR_WB_PROJECT"));
		
		fProjText = new Text(wrkbenComp, SWT.SINGLE | SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		fProjText.setLayoutData(gd);
		fProjText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent evt) {
				displayProjectMessage();
				setPageComplete(isWorkbenchValid());
			}
		});
		
		fProjButton = new Button(wrkbenComp, SWT.CENTER | SWT.PUSH);
		fProjButton.setText(UIPlugin.getResourceString("STR_WB_BROWSE_BTN"));
		fProjButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent evt) {
				handleProjectButtonSelected();
			}
		});
		
		Label fMainLabel = new Label(wrkbenComp, SWT.NONE);
		fMainLabel.setText(UIPlugin.getResourceString("STR_WB_MAIN_CLASS")); 

		fMainText = new Text(wrkbenComp, SWT.SINGLE | SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		fMainText.setLayoutData(gd);
		fMainText.addModifyListener(this);
				
		fSearchButton = new Button(wrkbenComp, SWT.CENTER | SWT.PUSH);
		fSearchButton.setText(UIPlugin.getResourceString("STR_WB_SEARCH_BTN"));
		fSearchButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent evt) {
				handleSearchButtonSelected();
			}
		});
		
		Label space = new Label(wrkbenComp,SWT.NONE);
  }
  
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 2:37:13 PM)
 * @param enable boolean
 */
private void enableWorkbench(boolean enable)
{
	fProjText.setEnabled(enable);
	fProjButton.setEnabled(enable);
	fMainText.setEnabled(enable);
	fSearchButton.setEnabled(enable);
		
	_processUI.enable(!enable, true, !enable, true, true);

	if(enable)
	{
	   fProjText.setFocus();
	}
}

  public boolean finish(String selectedProject, String selectedMonitor, String profileFile)
  {
  	_selectedProject = selectedProject;
  	_selectedMonitor = selectedMonitor;
  	_profileFile = profileFile;
  	return finish();
  	
  }
  
  private boolean success = true;
  public boolean finish()
  {
	org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
	public void run() {
	  TraceArguments trace = null;

	  String classname = "";	
	  if(_systemBtn.getSelection())
	  {
		  classname = _processUI.getClassUI().getText().trim();
	  }
	  else
	  {
			classname = fMainText.getText().trim();
	  }

	  trace = new TraceArguments(classname);
	  
	  if (_profileFile!=null || _profileFile.trim().equals(""))
	  	trace.setProfileFile(_profileFile);
	  	
	  trace.setHostName("localhost");	//$NON-NLS-1$
	  trace.setClassPath(_processUI.getClassPath());
	  trace.setVMArguments(_processUI.getVMArgs().trim());
	  trace.setParameters(_processUI.getParametersUI().getText().trim());
  	  trace.setPortNumber(Integer.parseInt(UIPlugin.getDefault().getPreferenceStore().getString(HyadesConstants.LOCALHOST_PORT)));
	  trace.setEnvironmentVariable(_processUI.getEnvData());
	  
		ArrayList filters = new ArrayList();

        if(((LaunchLocalWizard)getWizard()).isProfilingEnabled())
        {	
			trace.setAutoMonitoring(((LaunchLocalWizard)getWizard()).getAutoMonitoring());
			
			ArrayList filterSet = ((LaunchLocalWizard)getWizard()).getFilterSet();
			for(int idx=0; idx<filterSet.size(); idx++)
			{
				FilterSetElement elems = (FilterSetElement)filterSet.get(idx);
				if(elems.getEnabled())
				{
					UIPlugin.getDefault().getPluginPreferences().setValue(TraceConstants.ACTIVE_FILTER_NAME, elems.getName());
		            filters = elems.getChildren();
					break;
				}
			}
        }

	
	   if(trace.getType()!= null)
	   {
		  UIPlugin.getDefault().getTraceManager().registerTrace(trace.getType());
	   }

		
 	   success =  PDCoreUtil.launchTrace(trace
		   , filters
		   , ((LaunchLocalWizard)getWizard()).getOptions()
		   , _selectedProject
		   , _selectedMonitor);

	}
	});
	
	return success;
  }
 /**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */
public String getClassName() {
	return _processUI.getClassName();
}/**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */
public String getClassPath()
{
	return _processUI.getClassPath();
}

/**
 * Insert the method's description here.
 * Creation date: (08/21/2000 7:51:52 PM)
 * @param event com.ibm.swt.events.ModifyEvent
 */
public void modifyText(ModifyEvent event)
{
	if(_systemBtn.getSelection())
	{
		setPageComplete(!_processUI.getClassUI().getText().trim().equals(""));
	}
	else
	{
	   setPageComplete(isWorkbenchValid());
   }
}
/**
 * Insert the method's description here.
 * Creation date: (8/10/2001 2:10:31 PM)
 * @param obj java.lang.Object
 */
private void saveData(Object obj)
{
	if(obj == null)
	  return;
	
	ArgumentData data
	  = new ArgumentData(_processUI.getClassPath()
		  				, _processUI.getParameters()
		  				, _processUI.getVMArgs());
	_classArgs.put(obj, data);
}
/**
 * Insert the method's description here.
 * Creation date: (8/10/2001 12:00:04 PM)
 * @param idx int
 */
private void showClassArguments(IType type)
{
	String classname = "";

	if(type != null)
	{
		try {
			IJavaProject project = type.getJavaProject();

			//classname
			classname = type.getFullyQualifiedName();

			//classpath
			IWorkspace workbench = UIPlugin.getPluginWorkbench();
			IPath wpath = workbench.getRoot().getLocation();
			String prjpath = project.getProject().getLocation().toOSString();

			String classpath="";
			if(!prjpath.startsWith(wpath.toOSString()))	
				 classpath = prjpath+File.pathSeparator;	
		
	        String[] clspth = JavaRuntime.computeDefaultRuntimeClassPath(project);
	        for(int i=0;i<clspth.length;i++)
			classpath += clspth[i] + File.pathSeparator;
			
				 					
			_processUI.getClassPathUI().setText(classpath.trim());
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/10/2001 12:00:04 PM)
 * @param idx int
 */
private void showClassArguments(String name)
{
	if(name == null || name.equals(""))
	{
		_processUI.getClassPathUI().setText("");
		return;
	}
	
	Object obj = _classArgs.get(name);
	if(obj != null)
	{
	    ArgumentData data = (ArgumentData) obj;
		_processUI.getClassPathUI().setText(data.getClasspath());
	}
}
public void widgetDefaultSelected(SelectionEvent e)
{
}
public void widgetSelected(SelectionEvent e)
{	

	if(e.widget == _workbenchBtn && _workbenchBtn.getSelection())
	{
	   String name = _processUI.getClassUI().getText().trim();
	   if(!name.equals(""))
	      saveData(name);

		showClassArguments(fMainText.getText().trim());
	   	enableWorkbench(true);
	   	displayProjectMessage();
	    setPageComplete(isWorkbenchValid());
	}
	else if(e.widget == _systemBtn && _systemBtn.getSelection())
	{
   	   String name = fMainText.getText().trim();
	   if(!name.equals(""))
	   	saveData(name);
	  
  	   showClassArguments(_processUI.getClassUI().getText().trim());
  	   enableWorkbench(false);
	   setErrorMessage(null);
	   setPageComplete((!_processUI.getClassUI().getText().trim().equals("")));
		setMessage(null);
	}
}

	protected void handleProjectButtonSelected() {
		IJavaProject project = chooseJavaProject();
		if (project == null) {
			return;
		}
		
		String projectName = project.getElementName();
		fProjText.setText(projectName);
		setPageComplete(isWorkbenchValid());		
	}

	protected IJavaProject chooseJavaProject() {
		IJavaProject[] projects;
		try {
			projects= JavaCore.create(UIPlugin.getPluginWorkbench().getRoot()).getJavaProjects();
		} catch (JavaModelException e) {
			projects= new IJavaProject[0];
		}
		
		ILabelProvider labelProvider= new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
		ElementListSelectionDialog dialog= new ElementListSelectionDialog(getShell(), labelProvider);
		dialog.setTitle(UIPlugin.getResourceString("TITLE_PROJECT_SELECT"));
		dialog.setMessage(UIPlugin.getResourceString("STR_PROJECT_SELECT"));
		dialog.setElements(projects);
		
		IJavaProject javaProject = getJavaProject();
		if (javaProject != null) {
			dialog.setInitialSelections(new Object[] { javaProject });
		}
		if (dialog.open() == Window.OK) {			
			return (IJavaProject) dialog.getFirstResult();
		}			
		return null;		
	}

	protected IJavaProject getJavaProject() {
		String projectName = fProjText.getText().trim();
		if (projectName.length() < 1) {
			return null;
		}
		return getJavaModel().getJavaProject(projectName);		
	}
	
		private IJavaModel getJavaModel() {
		return JavaCore.create(UIPlugin.getPluginWorkbench().getRoot());
	}

	protected void handleSearchButtonSelected() {

		IJavaProject javaProject = getJavaProject();
		IJavaSearchScope searchScope = null;
		if ((javaProject == null) || !javaProject.exists()) {
			searchScope = SearchEngine.createWorkspaceScope();
		} else {
			searchScope = SearchEngine.createJavaSearchScope(new IJavaElement[] {javaProject}, false);
		}		
		
		int constraints = IJavaElementSearchConstants.CONSIDER_BINARIES;
		
		Shell shell = getShell();
		SelectionDialog dialog = JavaUI.createMainTypeDialog(shell, 
															 (WizardDialog) getWizard().getContainer(), 
															 searchScope, 
															 constraints, 
															 false, 
															 fMainText.getText()); 
		dialog.setTitle(UIPlugin.getResourceString("TITLE_MAIN_SELECT"));
		dialog.setMessage(UIPlugin.getResourceString("STR_MAIN_SELECT"));

		if (dialog.open() == Window.CANCEL) {
			setWorkbenchBtnSelection(true);
			return;
		}
		
		Object[] results = dialog.getResult();
		if ((results == null) || (results.length < 1)) {
			setWorkbenchBtnSelection(true);
			return;
		}		
		IType type = (IType)results[0];
		if (type != null) {
			fMainText.setText(type.getFullyQualifiedName());
			javaProject = type.getJavaProject();
			fProjText.setText(javaProject.getElementName());
			showClassArguments(type);
		}
		setWorkbenchBtnSelection(true);

	}

	private void displayProjectMessage()
	{
		IJavaProject javaProject = getJavaProject();
				if (fProjText.getText().trim().equals("")) {
					setErrorMessage(UIPlugin.getResourceString("WIZ_ERR_EMPTY_PROJECT"));
				}
				else if ((javaProject == null) || !javaProject.exists()) {
					setErrorMessage(UIPlugin.getResourceString("WIZ_ERR_NOT_EXIST_PROJECT"));
				}
				else {
					setErrorMessage(null);
				}
	}
	
	private void setWorkbenchBtnSelection(boolean enable)
	{
		_systemBtn.setSelection(!enable);
		_workbenchBtn.setSelection(enable);
		setPageComplete(isWorkbenchValid());
	}
	
	private boolean isWorkbenchValid()	{
		boolean isValid=false;
		
		IJavaProject javaProject = getJavaProject();
		isValid = ((javaProject != null) && javaProject.exists())
					& (!fMainText.getText().trim().equals(""));	
		return isValid; 
	
	}


}
