/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/*
* CONTEXT_ID prdp0000 for process remote data wizard page
*/

public class ProcessRemoteDataPage  extends WizardPage
									implements ModifyListener
{
	private LaunchProcessUI _processUI;

	private String          _selectedProject;
	private String	        _selectedMonitor;
	private boolean 		_validPort;
	private String			_profileFile;
	
public ProcessRemoteDataPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("PROCESS_WIZARD_TITLE"));

	String desc = UIPlugin.getResourceString("PROCESSREMOTEDATAPAGE_DESC");
	setDescription(desc);  
	setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH)); 
  }  
  public void createControl(Composite parent)
  {
	GridLayout layout;
	
	Composite btnGroup = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=10;      
	btnGroup.setLayout(layout);
	btnGroup.setLayoutData(GridUtil.createFill());
	
	Composite pGroup = new Composite(btnGroup, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.marginWidth = 10;
	pGroup.setLayout(layout);
	pGroup.setLayoutData(GridUtil.createHorizontalFill());

	_processUI = new LaunchProcessUI(); 
	Composite systemControl = _processUI.createControl(pGroup);
	
	_processUI.enable(true, true, false, false, true);
	_processUI.getClassUI().addModifyListener(this);
	
	setPageComplete(false);
		
	setControl(btnGroup);
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this.getControl(),
		UIPlugin.getPluginId()+".prdp0000");
  }  
  
    public boolean finish(String selectedProject, String selectedMonitor, String profileFile)
  {
  	_selectedProject = selectedProject;
  	_selectedMonitor = selectedMonitor;
  	_profileFile = profileFile;
  	return finish();
  	
  }
  
  private boolean success = true;
  public boolean finish()  
  {
  	org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
	public void run() {
	  TraceArguments trace = new TraceArguments(_processUI.getClassName());
	  if (_profileFile!=null || _profileFile.trim().equals(""))
	  	trace.setProfileFile(_profileFile);	  
	  trace.setHostName(((LaunchRemoteWizard)getWizard()).getHostName());
	  trace.setClassPath(_processUI.getClassPath());
	  trace.setParameters(_processUI.getParametersUI().getText().trim());
	  trace.setVMArguments(_processUI.getVMArgs().trim());
	  trace.setPortNumber(((LaunchRemoteWizard)getWizard()).getPortNumber());
  	  trace.setEnvironmentVariable(_processUI.getEnvData());
	  
	  ArrayList filters = new ArrayList();
      if(((LaunchRemoteWizard)getWizard()).isProfilingEnabled())
      {
		trace.setAutoMonitoring(((LaunchRemoteWizard)getWizard()).getAutoMonitoring());
		
		ArrayList filterSet = ((LaunchRemoteWizard)getWizard()).getFilterSet();
		for(int idx=0; idx<filterSet.size(); idx++)
		{
			FilterSetElement elems = (FilterSetElement)filterSet.get(idx);
			if(elems.getEnabled())
			{
				UIPlugin.getDefault().getPluginPreferences().setValue(TraceConstants.ACTIVE_FILTER_NAME, elems.getName());				
	            filters = elems.getChildren();
				break;
			}
		}
      }
	  
	  success = PDCoreUtil.launchTrace(trace
		       , filters
		       , ((LaunchRemoteWizard)getWizard()).getOptions()
		       , _selectedProject
			   , _selectedMonitor);		       
	}
  	});
  	
	return success;
  }    
 /**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */
public String getClassName() {
	return _processUI.getClassName();
}/**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */ 
public String getClassPath()
{
	return _processUI.getClassPath();  
}
/**
 * Sent when the text is modified.
 *
 * @param e an event containing information about the modify
 */
public void modifyText(ModifyEvent e)
{
	setPageComplete((!_processUI.getClassUI().getText().trim().equals("")) && _validPort);
}

public void setVisible(boolean visible) {
	
	super.setVisible(visible);
	
	if (visible) {
		org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
			public void run() {
				String host = ((LaunchRemoteWizard)getWizard()).getHostName();
				String port = String.valueOf(((LaunchRemoteWizard)getWizard()).getPortNumber());
				
				int status = HyadesUtil.testConnection(host,port,false,getShell());
				
				if (status != HyadesUtil.CONNECTION_SUCCESS)
					_validPort = false;
				else
					_validPort = true;
			}
		});
	}
}

}
