/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.List;
import java.util.Locale;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPage;
import org.eclipse.hyades.log.ui.internal.views.LogViewerUI;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchRecordDialog extends Dialog implements SelectionListener
{
	private CBEAdvFilterUI _filters;
	private Button btnFind;
	private Button btnCancel;
	private Button btnUp;
	private Button btnDown;
	private Label lblMessage;
	private LogRecordSearch logRecordSearch = null;
	private Tree tree;
	private List cbeList;
	private LogPage page;
	private java.lang.String _title;
	private Object lastMatch = null;

	public SearchRecordDialog(Shell shell, String windowTitle, Image windowImage, LogPage logPage) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);
		this.page = logPage;
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}

	protected Control createContents(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 0;
		c.setLayout(layout);
		data = GridUtil.createFill();
		data.widthHint = 500;
		c.setLayoutData(data);

		_filters =  new CBEAdvFilterUI();
		_filters.createControl(c,LogUIPlugin.getResourceString("STR_SEARCH_CONTENT_LABEL"));
		initializeFilters();

		Label hLine = new Label(c,SWT.SEPARATOR  | SWT.HORIZONTAL);
		data = new GridData(GridData.FILL_HORIZONTAL);
		hLine.setLayoutData(data);
		
		Composite b = new Composite(c,SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 0;
		b.setLayout(layout);
		data = GridUtil.createFill();
		b.setLayoutData(data);

		createOptionsGroup(b);
		createButtonsGroup(b);
		createFooter(c);
		
		initializeButtons();
		
		btnFind.addSelectionListener(this);
		btnCancel.addSelectionListener(this);
		_filters.getAddBtn().addSelectionListener(this);
		_filters.getRemoveBtn().addSelectionListener(this);
		
		WorkbenchHelp.setHelp(c, ContextIds.ACTLOG_VIEW_DIALOG_SEARCH);

		return c;
	}
	
	private void initializeFilters() {
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		String filters = store.getString(LogUIConstants.PD_SEARCH_FILTER_OPTIONS);
		_filters.initializeFilters(filters);
	}
	
	private void initializeButtons() {
		if (LogUIPlugin.getDefault().getPreferenceStore().getString(LogUIConstants.PD_SEARCH_DIRECTION_OPTIONS).equals("1"))
		{		btnDown.setSelection(true); } 
		else
		{ btnUp.setSelection(true); }
		btnFind.setEnabled(_filters.getFilterList().getFilters().size()>0);
	}
	
	private void createOptionsGroup(Composite c){

			Composite options = new Composite(c, SWT.NONE);
			GridLayout layout = new GridLayout();
			layout.numColumns = 1;
			options.setLayout(layout);
			options.setLayoutData(GridUtil.createHorizontalFill());
			
			Group direction = new Group(options, SWT.NONE);
			layout = new GridLayout();
			
			layout.numColumns = 2;
			
			direction.setText(LogUIPlugin.getResourceString("STR_DIRECTION_LABEL"));
			direction.setLayout(layout);
			GridData data =  new GridData(GridData.FILL_HORIZONTAL);
			data.horizontalAlignment = GridData.BEGINNING;
			data.widthHint = 300;
			direction.setLayoutData(data);
			btnUp = new Button(direction, SWT.RADIO);
			btnUp.setText(LogUIPlugin.getResourceString("STR_DIR_UP_LABEL"));
			btnDown = new Button(direction, SWT.RADIO);
			btnDown.setText(LogUIPlugin.getResourceString("STR_DIR_DOWN_LABEL"));
//			btnDown.setSelection(true);
	}
	
	private void createButtonsGroup(Composite c){

			Composite buttons = new Composite(c, SWT.NONE);
			GridLayout layout = new GridLayout();
			layout.numColumns = 2;
			GridData data = GridUtil.createHorizontalFill();
			data.horizontalAlignment = GridData.END;
			buttons.setLayout(layout);
			buttons.setLayoutData(data);

			btnFind = new Button(buttons, SWT.PUSH);
			btnFind.setText(LogUIPlugin.getResourceString("STR_FINDNEXT_LABEL"));
			data = new GridData();
			//Need wider button for Chinese, and PTBR translation of "Find Next", i.e. "Localizar Proxima".
			if (Locale.getDefault().toString().equals("en_US"))
				data.widthHint = 75;
			else
				data.widthHint = 100;
			btnFind.setLayoutData(data);

			btnCancel = new Button(buttons, SWT.PUSH);
			btnCancel.setText(LogUIPlugin.getResourceString("STR_CANCEL_LABEL"));
			data = new GridData();
			//Need wider button for Chinese, and PTBR translation of "Find Next", i.e. "Localizar Proxima".
			if (Locale.getDefault().toString().equals("en_US"))
				data.widthHint = 75;
			else
				data.widthHint = 100;
			btnCancel.setLayoutData(data);

			// set the dialog's default button 
			Shell shell = c.getShell();
			if (shell != null) {
				shell.setDefaultButton(btnFind);
			}

//			btnFind.setEnabled(false);
	}
	
	private void createFooter(Composite c){
		lblMessage = new Label(c, SWT.NONE);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		lblMessage.setLayoutData(data);
	}

	private void setSelection(Object sel){	
		if(sel==null){
			lblMessage.setText(LogUIPlugin.getResourceString("STR_STRING_NOT_FOUND"));
			return;
		}
		
		EObject mofObject = page.getTraceViewer().getObjectToView(HyadesUtil.getMofObject());
		if(sel!=null && sel instanceof EObject)
		   page.getTraceViewer().setRecordSelection((EObject)sel, mofObject);	            	

		lastMatch = sel;
		page.getView().getViewer().reveal(lastMatch);
	}
	
	private Object getCBENode(Object object)
	{
		if (object instanceof CBECommonBaseEvent){
			return object;
		}
		else if (object instanceof EObject) {
			return getCBENode(((EObject)object).eContainer());
		}
		return null;
	}

	private Object getStartNode(){
			IStructuredSelection sel = (IStructuredSelection)(((LogPage)page).getView().getViewer().getSelection());
	
				Object object = sel.getFirstElement();;
				if (object instanceof CBECommonBaseEvent) {
					return object;
				}
				else if (object instanceof EObject) {
					return getCBENode(object);
				}
				else if (object instanceof FeatureNode) {
					return getCBENode(((FeatureNode)object).getElement());
				}
				else if (object instanceof TerminalNode) {
					return getCBENode(((TerminalNode)object).getTreeParent());
				}

			return null;	
	}


	public LogRecordSearch getRecordSearchEngine(){
		if(logRecordSearch==null){
			logRecordSearch = new LogRecordSearch();
		}
		
		 
		LogViewerUI ui = page.getView();
		if (ui != null && ui.getViewer() != null) {
			LogContentProvider logContentProvider = (LogContentProvider)ui.getViewer().getContentProvider();
			cbeList = logContentProvider.getCachedElements();
		}
	
		Object start = getStartNode();
		logRecordSearch.initialize(cbeList, start);
		return logRecordSearch;	 
	}

	public void widgetDefaultSelected(SelectionEvent e){
	}
	
	public void widgetSelected(SelectionEvent e){
		if(e.widget==btnCancel) {
			_filters.storeValues(LogUIPlugin.getDefault().getPreferenceStore(),LogUIConstants.PD_SEARCH_FILTER_OPTIONS);
			LogUIPlugin.getDefault().getPreferenceStore().setValue(LogUIConstants.PD_SEARCH_DIRECTION_OPTIONS, btnDown.getSelection()?"1":"-1");
			close();
		}
		
		if(e.widget==btnFind){
			lblMessage.setText("");
			Object sel = getRecordSearchEngine().search(_filters.getFilterList().getFilters(), btnDown.getSelection()?1:-1,lastMatch);
			setSelection(sel);
		}
		
		if (e.widget==_filters.getAddBtn()
			|| e.widget==_filters.getRemoveBtn()){
			btnFind.setEnabled(_filters.getFilterList().getSize()>0);
		}
			
	}	
}