/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.extensions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;

/**
 * 
 *
 */
public interface ILogRecordCorrelationEngine {
	
	/**This method sets the log record associations 
	 * according to a particular correlation schema.
	 * @param correlationContainerProxy - the correlation container, this should point to a correlation container and a correlation engine
	 * @param listOfRecordLists - the list of RecordLists 
	 * where each RecordList contains records of a particular log.
	 * @return void
	 */
	public void correlate(CorrelationContainerProxy correlationContainerProxy, EList listOfRecordLists);
}
