/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.internal.extensions;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;

public class TimeBasedLogRecordCorrelationEngineImpl implements ILogRecordCorrelationEngine{
	
	String correlationName;
	CorrelationEngine correlationEngine;
	CorrelationContainer correlationContainer;
	
	public TimeBasedLogRecordCorrelationEngineImpl(){
	}
	
	public void correlate(CorrelationContainerProxy correlationContainerProxy,EList list){
		
		correlationEngine = correlationContainerProxy.getCorrelationEngine();
		correlationContainer = correlationContainerProxy.getCorrelationContainer();

		if(correlationEngine==null)
		{	
			correlationName = LogCorrelatorPlugin.getResourceString("CORR_NAME");
			correlationEngine.setType(LogCorrelatorPlugin.getResourceString("CORR_TYPE"));
			correlationEngine.setName(LogCorrelatorPlugin.getResourceString("CORR_NAME"));
			// set the ID with the type for now
			correlationEngine.setId(LogCorrelatorPlugin.getResourceString("CORR_NAME"));
		}

		for(int i=0; i<list.size();i++){
		   if(list.get(i)!=null){
		   	   EList recordList = ((RecordList)list.get(i)).getList();
		   	   for(int k=0; k<recordList.size(); k++){
		   	      if(recordList.get(k)!=null){
		   	      		   	      	
		   	      	setPartners(recordList.get(k),list,i);
		   	      }
		   	   }
		   }	
		}		
	}
	
	private void setPartners(Object art, EList list, int currentListIndex){
		
		CBECommonBaseEvent artifact = (CBECommonBaseEvent)art;
	
	   	double artifactTime = CBEUtils.computeAdjustedCreationTime(artifact);
	   	EList recordList = null;
	   	 	         
	   	for(int i=0; i<list.size();i++){
	   	      recordList = ((RecordList)list.get(i)).getList();
	   	      if(recordList != null){
	   	         for(int k=0; k<recordList.size(); k++){
		   	        if(recordList.get(k)!=null){
		   	        	
		   	           if(i>currentListIndex || (i==currentListIndex && recordList.get(k)!=art)){

		   	      	      if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)recordList.get(k))==artifactTime
		   	      	         && recordList.get(k)!=art){	
		   	      	      	addCorrelation((CBECommonBaseEvent)art,(CBECommonBaseEvent)recordList.get(k));
		   	      	       }
	   	      	         
		   	           }
		   	        }	
	   	         }
	   	      }
	   	}
	}

	/**
	 * @param artifact
	 * @return
	 */
	private EList addCorrelation(CBECommonBaseEvent artifact,CBECommonBaseEvent associtatedEvent) {
		EList correlations = (EList)correlationContainer.getCorrelations().get(artifact);
		if(correlations==null)
		{
			correlations = new BasicEList();
			correlations.add(associtatedEvent);
			correlationContainer.getCorrelations().put(artifact,correlations);
		}
		else
		{
			correlations.add(associtatedEvent);
		}
		return correlations;
	}
}
