/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.probekit.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Data Enum</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.probekit.internal.ProbekitPackage#getDataEnum()
 * @model
 * @generated
 */
public final class DataEnum extends AbstractEnumerator {
	/**
	 * The '<em><b>Class Name</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLASS_NAME_LITERAL
	 * @model name="className"
	 * @generated
	 * @ordered
	 */
	public static final int CLASS_NAME = 1;

	/**
	 * The '<em><b>Method Name</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #METHOD_NAME_LITERAL
	 * @model name="methodName"
	 * @generated
	 * @ordered
	 */
	public static final int METHOD_NAME = 2;

	/**
	 * The '<em><b>Method Sig</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #METHOD_SIG_LITERAL
	 * @model name="methodSig"
	 * @generated
	 * @ordered
	 */
	public static final int METHOD_SIG = 3;

	/**
	 * The '<em><b>This Object</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #THIS_OBJECT_LITERAL
	 * @model name="thisObject"
	 * @generated
	 * @ordered
	 */
	public static final int THIS_OBJECT = 4;

	/**
	 * The '<em><b>Args</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ARGS_LITERAL
	 * @model name="args"
	 * @generated
	 * @ordered
	 */
	public static final int ARGS = 5;

	/**
	 * The '<em><b>Returned Object</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RETURNED_OBJECT_LITERAL
	 * @model name="returnedObject"
	 * @generated
	 * @ordered
	 */
	public static final int RETURNED_OBJECT = 6;

	/**
	 * The '<em><b>Is Finally</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IS_FINALLY_LITERAL
	 * @model name="isFinally"
	 * @generated
	 * @ordered
	 */
	public static final int IS_FINALLY = 7;

	/**
	 * The '<em><b>Exception Object</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXCEPTION_OBJECT_LITERAL
	 * @model name="exceptionObject"
	 * @generated
	 * @ordered
	 */
	public static final int EXCEPTION_OBJECT = 8;

	/**
	 * The '<em><b>Class Name</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Class Name</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLASS_NAME
	 * @generated
	 * @ordered
	 */
	public static final DataEnum CLASS_NAME_LITERAL = new DataEnum(CLASS_NAME, "className");

	/**
	 * The '<em><b>Method Name</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Method Name</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #METHOD_NAME
	 * @generated
	 * @ordered
	 */
	public static final DataEnum METHOD_NAME_LITERAL = new DataEnum(METHOD_NAME, "methodName");

	/**
	 * The '<em><b>Method Sig</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Method Sig</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #METHOD_SIG
	 * @generated
	 * @ordered
	 */
	public static final DataEnum METHOD_SIG_LITERAL = new DataEnum(METHOD_SIG, "methodSig");

	/**
	 * The '<em><b>This Object</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>This Object</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #THIS_OBJECT
	 * @generated
	 * @ordered
	 */
	public static final DataEnum THIS_OBJECT_LITERAL = new DataEnum(THIS_OBJECT, "thisObject");

	/**
	 * The '<em><b>Args</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Args</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ARGS
	 * @generated
	 * @ordered
	 */
	public static final DataEnum ARGS_LITERAL = new DataEnum(ARGS, "args");

	/**
	 * The '<em><b>Returned Object</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Returned Object</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RETURNED_OBJECT
	 * @generated
	 * @ordered
	 */
	public static final DataEnum RETURNED_OBJECT_LITERAL = new DataEnum(RETURNED_OBJECT, "returnedObject");

	/**
	 * The '<em><b>Is Finally</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Is Finally</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #IS_FINALLY
	 * @generated
	 * @ordered
	 */
	public static final DataEnum IS_FINALLY_LITERAL = new DataEnum(IS_FINALLY, "isFinally");

	/**
	 * The '<em><b>Exception Object</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Exception Object</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXCEPTION_OBJECT
	 * @generated
	 * @ordered
	 */
	public static final DataEnum EXCEPTION_OBJECT_LITERAL = new DataEnum(EXCEPTION_OBJECT, "exceptionObject");

	/**
	 * An array of all the '<em><b>Data Enum</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final DataEnum[] VALUES_ARRAY =
		new DataEnum[] {
			CLASS_NAME_LITERAL,
			METHOD_NAME_LITERAL,
			METHOD_SIG_LITERAL,
			THIS_OBJECT_LITERAL,
			ARGS_LITERAL,
			RETURNED_OBJECT_LITERAL,
			IS_FINALLY_LITERAL,
			EXCEPTION_OBJECT_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Data Enum</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Data Enum</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DataEnum get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			DataEnum result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Data Enum</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DataEnum get(int value) {
		switch (value) {
			case CLASS_NAME: return CLASS_NAME_LITERAL;
			case METHOD_NAME: return METHOD_NAME_LITERAL;
			case METHOD_SIG: return METHOD_SIG_LITERAL;
			case THIS_OBJECT: return THIS_OBJECT_LITERAL;
			case ARGS: return ARGS_LITERAL;
			case RETURNED_OBJECT: return RETURNED_OBJECT_LITERAL;
			case IS_FINALLY: return IS_FINALLY_LITERAL;
			case EXCEPTION_OBJECT: return EXCEPTION_OBJECT_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private DataEnum(int value, String name) {
		super(value, name);
	}

} //DataEnum
