/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.util.List;

/**
 * 
 * A block is a container for a group of actions.  A block can be visualized as
 * a set of curly braces in the source code.  In this visualization, the code 
 * within those curly braces is represented by the block's list of actions.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface IBlock extends INamedElement {
	
	/**
	 * Returns the list of actions that are contained by this block.  Implementors
	 * must enforce that all objects in the list are instances of {@link IAction}.
	 * 
	 * @return a unidirectional list of references
	 */
	public List getActions();
}
