/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;

import org.eclipse.emf.common.util.AbstractEnumerator;

import org.eclipse.hyades.models.common.common.CommonPlugin;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>TPF Invocation Status</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFInvocationStatus()
 * @model
 * @generated
 */
public final class TPFInvocationStatus extends AbstractEnumerator
{
	/**
	 * The '<em><b>Unattempted</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNATTEMPTED_LITERAL
	 * @model name="unattempted"
	 * @generated
	 * @ordered
	 */
	public static final int UNATTEMPTED = 0;

	/**
	 * The '<em><b>Successful</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SUCCESSFUL_LITERAL
	 * @model name="successful"
	 * @generated
	 * @ordered
	 */
	public static final int SUCCESSFUL = 1;

	/**
	 * The '<em><b>Unsuccessful</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNSUCCESSFUL_LITERAL
	 * @model name="unsuccessful"
	 * @generated
	 * @ordered
	 */
	public static final int UNSUCCESSFUL = 2;

	/**
	 * The '<em><b>Unattempted</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Unattempted</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #UNATTEMPTED
	 * @generated
	 * @ordered
	 */
	public static final TPFInvocationStatus UNATTEMPTED_LITERAL = new TPFInvocationStatus(UNATTEMPTED, "unattempted");

	/**
	 * The '<em><b>Successful</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Successful</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SUCCESSFUL
	 * @generated
	 * @ordered
	 */
	public static final TPFInvocationStatus SUCCESSFUL_LITERAL = new TPFInvocationStatus(SUCCESSFUL, "successful");

	/**
	 * The '<em><b>Unsuccessful</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Unsuccessful</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #UNSUCCESSFUL
	 * @generated
	 * @ordered
	 */
	public static final TPFInvocationStatus UNSUCCESSFUL_LITERAL = new TPFInvocationStatus(UNSUCCESSFUL, "unsuccessful");

	/**
	 * An array of all the '<em><b>TPF Invocation Status</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TPFInvocationStatus[] VALUES_ARRAY =
		new TPFInvocationStatus[] {
			UNATTEMPTED_LITERAL,
			SUCCESSFUL_LITERAL,
			UNSUCCESSFUL_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>TPF Invocation Status</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>TPF Invocation Status</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFInvocationStatus get(String name)
	{
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TPFInvocationStatus result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TPF Invocation Status</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFInvocationStatus get(int value)
	{
		switch (value) {
			case UNATTEMPTED: return UNATTEMPTED_LITERAL;
			case SUCCESSFUL: return SUCCESSFUL_LITERAL;
			case UNSUCCESSFUL: return UNSUCCESSFUL_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TPFInvocationStatus(int value, String name)
	{
		super(value, name);
	}

	/**
	 * Returns the enumeration value associated with a 
	 * label.
	 * 
	 * <p>If the label is not valid then this method
	 * returns the default value for the enumeration.
	 * 
	 * @param label
	 * @return TPFInvocationStatus
	 */
	public static TPFInvocationStatus getByLabel(String label)
	{
		if(label != null)
		{
			for (int i = 0, maxi=VALUES_ARRAY.length; i < maxi; i++)
			{
				if(label.equals(VALUES_ARRAY[i].getLabel()))
					return VALUES_ARRAY[i];
			}
		}
		return get(label);	
	}	
	
	private final String keyPrefix = getClass().getName() + ".";
	
	/**
	 * Returns the label associated with this enumeration value.  If
	 * there is no label then this method returns the enumeration's name.
	 * @return String
	 */
	public String getLabel()
	{
		try
		{
			String label = getString(keyPrefix + getName());
			if(label != null)
				return label;
		}
		catch(MissingResourceException e)
		{
		} 

		return getName();
	}
	
	/**
	 * Returns the string value associated with a given key.
	 * @param key
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	protected String getString(String key)
	throws NullPointerException, MissingResourceException
	{
		return CommonPlugin.getString(key);
	}	
} //TPFInvocationStatus
