/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFArbiter;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Behavior</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getIsReentrant <em>Is Reentrant</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getResource <em>Resource</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getInteraction <em>Interaction</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getArbiter <em>Arbiter</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getTestComponent <em>Test Component</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getTest <em>Test</em>}</li>
 * </ul>
 * </p>
 *
 * @extends IImplementor
 * @generated NOT
 */
public class TPFBehaviorImpl extends CMNNamedElementImpl implements TPFBehavior, IImplementor
{
	/**
	 * The default value of the '{@link #getIsReentrant() <em>Is Reentrant</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsReentrant()
	 * @generated
	 * @ordered
	 */
	protected static final Boolean IS_REENTRANT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIsReentrant() <em>Is Reentrant</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsReentrant()
	 * @generated
	 * @ordered
	 */
	protected Boolean isReentrant = IS_REENTRANT_EDEFAULT;

	/**
	 * The default value of the '{@link #getResource() <em>Resource</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResource()
	 * @generated
	 * @ordered
	 */
	protected static final String RESOURCE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResource() <em>Resource</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResource()
	 * @generated
	 * @ordered
	 */
	protected String resource = RESOURCE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected String location = LOCATION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInteraction() <em>Interaction</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteraction()
	 * @generated
	 * @ordered
	 */
	protected BVRInteraction interaction = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFBehaviorImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_TestprofilePackage.eINSTANCE.getTPFBehavior();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Boolean getIsReentrant()
	{
		return isReentrant;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsReentrant(Boolean newIsReentrant)
	{
		Boolean oldIsReentrant = isReentrant;
		isReentrant = newIsReentrant;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT, oldIsReentrant, isReentrant));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getResource()
	{
		return resource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResource(String newResource)
	{
		String oldResource = resource;
		resource = newResource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE, oldResource, resource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocation()
	{
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(String newLocation)
	{
		String oldLocation = location;
		location = newLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION, oldLocation, location));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteraction getInteraction()
	{
		return interaction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInteraction(BVRInteraction newInteraction, NotificationChain msgs)
	{
		BVRInteraction oldInteraction = interaction;
		interaction = newInteraction;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, oldInteraction, newInteraction);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteraction(BVRInteraction newInteraction)
	{
		if (newInteraction != interaction) {
			NotificationChain msgs = null;
			if (interaction != null)
				msgs = ((InternalEObject)interaction).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, BVRInteraction.class, msgs);
			if (newInteraction != null)
				msgs = ((InternalEObject)newInteraction).eInverseAdd(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, BVRInteraction.class, msgs);
			msgs = basicSetInteraction(newInteraction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, newInteraction, newInteraction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFArbiter getArbiter()
	{
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER) return null;
		return (TPFArbiter)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setArbiter(TPFArbiter newArbiter)
	{
		if (newArbiter != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER && newArbiter != null)) {
			if (EcoreUtil.isAncestor(this, newArbiter))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newArbiter != null)
				msgs = ((InternalEObject)newArbiter).eInverseAdd(this, Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS, TPFArbiter.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newArbiter, Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER, newArbiter, newArbiter));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTestComponent getTestComponent()
	{
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT) return null;
		return (TPFTestComponent)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestComponent(TPFTestComponent newTestComponent)
	{
		if (newTestComponent != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT && newTestComponent != null)) {
			if (EcoreUtil.isAncestor(this, newTestComponent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTestComponent != null)
				msgs = ((InternalEObject)newTestComponent).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS, TPFTestComponent.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTestComponent, Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT, newTestComponent, newTestComponent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTest getTest()
	{
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_BEHAVIOR__TEST) return null;
		return (TPFTest)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTest(TPFTest newTest)
	{
		if (newTest != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_BEHAVIOR__TEST && newTest != null)) {
			if (EcoreUtil.isAncestor(this, newTest))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTest != null)
				msgs = ((InternalEObject)newTest).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST__BEHAVIOR, TPFTest.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTest, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, newTest, newTest));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
					if (interaction != null)
						msgs = ((InternalEObject)interaction).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, null, msgs);
					return basicSetInteraction((BVRInteraction)otherEnd, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
					return basicSetInteraction(null, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS, TPFArbiter.class, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS, TPFTestComponent.class, msgs);
				case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_TEST__BEHAVIOR, TPFTest.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__ID:
				return getId();
			case Common_TestprofilePackage.TPF_BEHAVIOR__NAME:
				return getName();
			case Common_TestprofilePackage.TPF_BEHAVIOR__DESCRIPTION:
				return getDescription();
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				return getIsReentrant();
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				return getResource();
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				return getLocation();
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				return getInteraction();
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				return getArbiter();
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				return getTestComponent();
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				return getTest();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__ID:
				setId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__NAME:
				setName((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				setIsReentrant((Boolean)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				setResource((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				setLocation((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				setInteraction((BVRInteraction)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				setArbiter((TPFArbiter)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				setTestComponent((TPFTestComponent)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				setTest((TPFTest)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				setIsReentrant(IS_REENTRANT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				setResource(RESOURCE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				setLocation(LOCATION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				setInteraction((BVRInteraction)null);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				setArbiter((TPFArbiter)null);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				setTestComponent((TPFTestComponent)null);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				setTest((TPFTest)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_TestprofilePackage.TPF_BEHAVIOR__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_TestprofilePackage.TPF_BEHAVIOR__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				return IS_REENTRANT_EDEFAULT == null ? isReentrant != null : !IS_REENTRANT_EDEFAULT.equals(isReentrant);
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				return RESOURCE_EDEFAULT == null ? resource != null : !RESOURCE_EDEFAULT.equals(resource);
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				return interaction != null;
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				return getArbiter() != null;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				return getTestComponent() != null;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				return getTest() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (isReentrant: ");
		result.append(isReentrant);
		result.append(", resource: ");
		result.append(resource);
		result.append(", location: ");
		result.append(location);
		result.append(')');
		return result.toString();
	}

	// TODO: This may need to be moved to a utility class in a future release
	public BVRLifelineImpl getSelfLifeline()
	{
		BVRLifelineImpl selfLifeline = null;
		
		// Determine if the owner of the behavior is a TestCase or a TestSuite
		// If the owner is a test case, find the owning test suite so we
		// can determine the CFGDeployable that is associated with the
		// self lifeline.
		ITest test = getOwner();
		
		if ( test != null && interaction != null )
		{
			TPFTestSuite suite;
			if ( test instanceof TPFTestCaseImpl )
			{
				suite = ((TPFTestCaseImpl)test).getTestSuite();
			}
			else if ( test instanceof TPFTestSuiteImpl )
			{
				suite = (TPFTestSuiteImpl) test;
			}
			else
			{
				return null;			
			}
		
			List lifelines = getInteraction().getLifelines();
			if ( !lifelines.isEmpty() )
			{
				Iterator it = lifelines.iterator();
				BVRLifeline lifeline;
				while ( it.hasNext() )
				{
					lifeline = (BVRLifeline) it.next();
					if(!lifeline.getInstances().isEmpty())
					{
						CFGClass deployable = ((CFGInstance)lifeline.getInstances().get(0)).getClassType();
						if ( deployable.equals(suite) )
						{
							selfLifeline = (BVRLifelineImpl) lifeline;
							break;
						}
					}
				}
			
			}
		}
		return selfLifeline;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IImplementor#getBlock()
	 */
	public IBlock getBlock() {
		return (BVRInteractionImpl)getInteraction();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public ITest getOwner() {
		return (ITest)getTest();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getMethods()
	 */
	public List getMethods()
	{
		if(getTest() != null)
		{
			if(getTest() instanceof TPFTestCase)
				return ((TPFTestCase)getTest()).getTestSuite().getOperations();
			
			if(getTest() instanceof TPFTestSuite)
				return ((TPFTestSuite)getTest()).getOperations();
		}
		
		if(getArbiter() != null)
			return getArbiter().getOperations();
			
		if(getTestComponent() != null)
			return getTestComponent().getOperations();
		
		return Collections.unmodifiableList(Collections.EMPTY_LIST);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IImplementor#isExternalImplementor()
	 */
	public boolean isExternalImplementor() {
		if(getBlock() == null)
		{	
			return true;
		}
		else
		{
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getEnvironmentVariables()
	 */
	public IPropertyGroup getEnvironmentVariables() {
		throw new UnsupportedOperationException();
	}

} //TPFBehaviorImpl
