/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.util;

import org.eclipse.hyades.sd.ui.*;
import org.eclipse.hyades.sd.ui.internal.model.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class DrawAreaFindDialog extends Dialog {
	
	List containerList;

	private int containerCount = 0;
	private Graph graph = null;
	private GraphNode[] containers = null;
	private GraphNode selectedNode = null;
	private TabFolder folder=null;
	private TabItem item=null;
    private SearchTab searchTab=null;

	public DrawAreaFindDialog(Shell parent, Graph graph) {
		super(parent);
		this.containers = graph.getTopNodes();
		this.containerCount = graph.getTopNodeCount();
		this.graph = graph;
	} 

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(SDPlugin.getString("STR_FIND"));
	}

	protected Control createContents(Composite parent) {
		Control control = super.createContents(parent);
		getButton().setText(SDPlugin.getString("STR_BUTTON_SEARCH"));
		getButton().setEnabled(false);
		return control;
	}
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		data = GridUtil.createFill();
		result.setLayoutData(data);

		folder = new TabFolder(result, SWT.NONE);
		data = GridUtil.createFill();
		data.heightHint = 200;
		data.widthHint = 300;
		folder.setLayoutData(data);
		
		//create search tab depending on graph type
		if (graph.getType() == Graph.CLASSoverMETHOD)
		{	
			createClassTab();
		}
		else if (graph.getType() == Graph.OBJECToverMETHOD)
		{
			createClassTab();
			createObjectTab();
		}
		else if (graph.getType() == Graph.NODEoverMETHOD)
		{
			createHostTab();
		}
		else if (graph.getType() == Graph.PROCESSoverMETHOD)
		{
			createProcessTab();
		}
		else if (graph.getType() == Graph.AGENToverMETHOD)
		{
			createAgentTab();
		}
		else if (graph.getType() == Graph.THREADoverMETHOD)
		{
			createThreadTab();
		}
		else if (graph.getType() == Graph.THREADoverRECORD)
		{
			createLogThreadTab();
		}
		else if (graph.getType() == Graph.LOGoverRECORD)
		{
			createLogTab();
		}
		
		return result;
	}

	protected void okPressed() {
		super.okPressed();
	}

	public GraphNode getSelectedNode() {
		return selectedNode;
	}

	public void setSelectedNode(GraphNode selectedNode) {
		this.selectedNode = selectedNode;
		getButton().setEnabled(selectedNode==null?false:true);			
	}
	
	private void createClassTab(){
		item = new TabItem(folder, SWT.NONE);
		item.setText(SDPlugin.getString("STR_CLASS_SEARCH"));
		item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_CLASS_SEARCH));
		searchTab = new SearchTab(containers, containerCount,GraphNode.CLASS, this);
		item.setControl(searchTab.createContents(folder));
	}
	
	private void createObjectTab(){
		item = new TabItem(folder, SWT.NONE);
		item.setText(SDPlugin.getString("STR_OBJECT_SEARCH"));
		item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_OBJECT_SEARCH));
		searchTab = new SearchTab(containers, containerCount, GraphNode.OBJECT, this);
		item.setControl(searchTab.createContents(folder));
	}	

	private void createHostTab(){
		item = new TabItem(folder, SWT.NONE);
		item.setText(SDPlugin.getString("STR_HOST_SEARCH"));
		item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_HOST_SEARCH));
		searchTab = new SearchTab(containers, containerCount, GraphNode.NODE, this);
		item.setControl(searchTab.createContents(folder));
	}	
	
	private void createAgentTab(){
			item = new TabItem(folder, SWT.NONE);
			item.setText(SDPlugin.getString("STR_AGENT_SEARCH"));
			item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_AGENT_SEARCH));
			searchTab = new SearchTab(containers, containerCount, GraphNode.AGENT, this);
			item.setControl(searchTab.createContents(folder));
		}	
	
	private void createProcessTab(){
		item = new TabItem(folder, SWT.NONE);
		item.setText(SDPlugin.getString("STR_PROCESS_SEARCH"));
		item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_PROCESS_SEARCH));
		searchTab = new SearchTab(containers, containerCount, GraphNode.PROCESS, this);
		item.setControl(searchTab.createContents(folder));
	}

	private void createThreadTab(){
		item = new TabItem(folder, SWT.NONE);
		item.setText(SDPlugin.getString("STR_THREAD_SEARCH"));
		item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_THREAD_SEARCH));
		searchTab = new SearchTab(containers, containerCount, GraphNode.THREAD, this);
		item.setControl(searchTab.createContents(folder));
	}
	
	private void createLogThreadTab(){
			item = new TabItem(folder, SWT.NONE);
			item.setText(SDPlugin.getString("STR_THREAD_SEARCH"));
			item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_LOG_SEARCH));
			searchTab = new SearchTab(containers, containerCount, GraphNode.LOG, this);
			item.setControl(searchTab.createContents(folder));
		}
	
	private void createLogTab(){
		item = new TabItem(folder, SWT.NONE);
		item.setText(SDPlugin.getString("STR_LOG_SEARCH"));
		item.setImage(SDPluginImages.getImage(SDPluginImages.IMG_LOG_SEARCH));
		searchTab = new SearchTab(containers, containerCount, GraphNode.LOG, this);
		item.setControl(searchTab.createContents(folder));
	}
	
	public Button getButton()
	{
		return getButton(IDialogConstants.OK_ID);
	}
}
