/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DrawAreaToolTip {

	private Composite parentComposite; //SDViewerUI
	private Shell toolTipShell;
	private Canvas textCanvas;
	private String text = null;
	private GC gc;
	private int xPos = 0, yPos = 0;
	
	/**
	 * Constructor for DrawAreaToolTip
	 * Instantiate in the constructor of the parent Control
	*/
	public DrawAreaToolTip(Composite c) {
		toolTipShell = new Shell(c.getShell(),SWT.ON_TOP|SWT.NO_BACKGROUND);
		toolTipShell.setSize(0,0);
		
		parentComposite = c;
		
		textCanvas = new Canvas(toolTipShell,0);
		textCanvas.setBackground(c.getDisplay().getSystemColor(SWT.COLOR_INFO_BACKGROUND));
		textCanvas.setForeground(c.getDisplay().getSystemColor(SWT.COLOR_INFO_FOREGROUND));
	}
	
	/**
	 * Call this paint method from the parent Control paintControl()
	*/
	public void paintControl(){
		if (text != null) {
			gc = new GC(textCanvas);
			Point textExtent = gc.stringExtent(text);
			textCanvas.setSize(textExtent.x+4,textExtent.y+1);
			
			//if tooltips width is over shell width, move the start position of tooltip left of the cursor
		    int xOverlap = xPos + (textExtent.x+4) - parentComposite.getShell().getDisplay().getBounds().width;
		    if(xOverlap>0) xPos-=xOverlap;
			
			toolTipShell.setLocation(xPos, yPos);
			toolTipShell.setVisible(true);
			gc.fillRectangle(textCanvas.getBounds());
			gc.drawString(text, 2, 0);
			toolTipShell.pack();
		}
	}
	
	/**
	 * Call it in parent Control mouse listener whenever the mouse cursor is above position
	 * for which toolTip is defined.
	*/
	public void showText(String t) {
		hideText();
		Point cursorLocation = parentComposite.getShell().getDisplay().getCursorLocation();
		xPos = cursorLocation.x + 20;
		yPos = cursorLocation.y + 20;
		text = t;
		paintControl();
	}
	
	/**
	 * Call it in parent Control mouse listener whenever the mouse cursor is above position
	 * for which toolTip is not supposed to show.
	*/
	public void hideText() {
		if (gc != null) {
			gc.dispose();
			text = null;
			toolTipShell.setVisible(false);
		}
	}

}
