/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * CONTEXT_ID refs0000 for Refresh action button in Sequence Diagram.
 * CONTEXT_ID zmin0000 for Zoom In action button in Sequence Diagram.
 * CONTEXT_ID zmot0000 for Zoom Out action button in Sequence Diagram.
 * CONTEXT_ID home0000 for Home action button in Sequence Diagram.
 * CONTEXT_ID noad0000 for Node agent interactions diagram
 * CONTEXT_ID nopd0000 for Node processes interactions diagram
 * CONTEXT_ID notd0000 for Node thread interactions diagram
 * CONTEXT_ID nocd0000 for Node class interactions diagram
 * CONTEXT_ID nood0000 for Node object interactions diagram
 * CONTEXT_ID nomd0000 for Node method interactions diagram
 * CONTEXT_ID aopd0000 for Agent process interactions diagram
 * CONTEXT_ID potd0000 for Process threads interactions diagram
 * CONTEXT_ID pood0000 for Process objects interactions diagram
 * CONTEXT_ID pocd0000 for Process classes interactions diagram
 * CONTEXT_ID pomd0000 for Process method interactions diagram
 * CONTEXT_ID aotd0000 for Agent thread interactions diagram
 * CONTEXT_ID aocd0000 for Agent class interactions diagram
 * CONTEXT_ID tocd0000 for Thread class interactions diagram
 * CONTEXT_ID aood0000 for Agent object interactions diagram
 * CONTEXT_ID tood0000 for Thread object interactions diagram
 * CONTEXT_ID aomd0000 for Agent method interactions diagram
 * CONTEXT_ID tomd0000 for Thread method interactions diagram
 * CONTEXT_ID oomd0000 for Object methods interactions diagram
 * CONTEXT_ID comd0000 for Class methods interactions diagram
 */

package org.eclipse.hyades.sd.ui.internal.views;

import java.util.*;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.*;
import org.eclipse.hyades.sd.ui.internal.model.*;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.action.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.*;

public class SDViewer
	extends TraceViewer
	implements IDeleteListener
{
	private Composite _parent;
	private PageBook book=null;
	private IPage currentPage;
	private IPage defaultPage;
	private boolean _initializedMenu = false;
	private boolean canZoom = true;
	public Action zoomOut,zoomIn,find,home,refresh;
	private TRCNode lastMofNode;
	private Object lastSelection;
	private int lastMofType=-1;
	
	private Object displaySelection;

	protected String STR_ZOOM_IN = SDPlugin.getString("STR_ZOOMIN");
	protected String STR_ZOOM_OUT = SDPlugin.getString("STR_ZOOMOUT");
	protected String STR_HOME = SDPlugin.getString("STR_HOME");
	protected String STR_FIND = SDPlugin.getString("STR_FIND");
	protected String STR_REFRESH = SDPlugin.getString("STR_REFRESH_SD_VIEW");
	
	protected Hashtable _pages = new Hashtable();

	class RefreshAction extends Action {
		 public RefreshAction(String name) {
			 super(name);
		 }
		 public void run() {
			ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
			event.setSource(HyadesUtil.getMofObject());
			event.setType(ProfileEvent.UPDATE_MODEL);			
			UIPlugin.getDefault().notifyProfileEventListener(event);
		 }
	 }

	class FindAction extends Action {
		 public FindAction(String name) {
			 super(name);
		 }
		public void run() {
				
			LogCDrawUtils.setTimeUnit(5);
			SDViewer.this.zoomOut.setEnabled(true);
			IPage page = getCurrentPage();

			if (page != null && page instanceof SDViewerPage) {
				((SDViewerUI)((SDViewerPage)page).getControl()).find();
				((SDViewerPage) page).update();
			}
		}
	 }
	 
	class ZoomInAction extends Action {
		 public ZoomInAction(String name) {
			 super(name);
		 }
		public void run() {
			LogCDrawUtils.increaseTimeUnit(1);
			IPage page = getCurrentPage();

			if (page != null && page instanceof SDViewerPage) {
				((SDViewerPage) page).update();
				SDViewer.this.zoomOut.setEnabled(true);
			}
		}
	 }
	
	class ZoomOutAction extends Action {
		 public ZoomOutAction(String name) {
			 super(name);
		 }
		public void run() {
			if (LogCDrawUtils.getTimeUnit() == 1) {
				setEnabled(false);
				return;
			}
			if (canZoom)
				setEnabled(true);
			LogCDrawUtils.decreaseTimeUnit(1);
			IPage page = getCurrentPage();

			if (page != null && page instanceof SDViewerPage) {
				((SDViewerPage) page).update();
			}
		}
	 }
	 
	class HomeAction extends Action {
		 public HomeAction(String name) {
			 super(name);
		 }
		public void run() {
				
			LogCDrawUtils.setTimeUnit(6);
			SDViewer.this.zoomOut.setEnabled(true);
			IPage page = getCurrentPage();

			if (page != null && page instanceof SDViewerPage) {
				((SDViewerUI)((SDViewerPage)page).getControl()).goHome();
				((SDViewerPage) page).update();
			}
		}
	 }


	public SDViewer() {
		super();
		setTitle(SDPlugin.getString("STR_VIEW_TITLE"));
		setTitleImage(SDPluginImages.getImage(SDPluginImages.IMG_IDATRACE));	
	}
	
	public void addViewPage(EObject object) { 
			addLoadViewPage(getObjectToView(object),getCurrentGraphType(),false);
			if (!(currentPage instanceof DefaultPage)) 
				putPage(object,(SDViewerPage)currentPage,getCurrentGraphType());
	}
	
	private boolean isValidForLoad(EObject mofObject,int graphType){
		if (book == null) {
			UIPlugin.getDefault().removeSelectionListener(this);
			return false;
		}
		if (mofObject == null || !isValidObject(mofObject,graphType)) {
			LogCDrawUtils.setWeightSelection(-1,null);
			LogCDrawUtils.setCurrentGraphType(graphType);	//needed for the title
			defaultPage = createDefaultPage(book);
			showPage(defaultPage);
			setViewTitle(mofObject);
			setLastMof(mofObject);
			return false;
		}
		return true;
	}
	
	public void addLoadViewPage(EObject mofObject, int graphType,boolean forceLoad) {
		if (!isValidForLoad(mofObject,graphType)) return;
		SDViewerPage page = (SDViewerPage)getPage(mofObject, graphType);

		//force to reload even page is found
		if (page!=null && forceLoad) 
		{
			LogCDrawUtils.setCurrentPage(page);
			page.loadModel(graphType,!(mofObject instanceof CorrelationContainerProxy));
		}

		//create and load if page is not found
		if (page == null) {
			
			page = (SDViewerPage) createPage(mofObject);
			page.createControl(book);
			LogCDrawUtils.setCurrentPage(page);
			if ((graphType==Graph.LOGoverRECORD 
					|| graphType==Graph.THREADoverRECORD) 
					&& !forceLoad){
				page.loadModel(graphType,null); //load model with no correlation schema
			}
			else {
				page.loadModel(graphType,!(mofObject instanceof CorrelationContainerProxy)); //load model and prompt for correlation type
			}
			if (page.isEmpty())
			{
				LogCDrawUtils.setWeightSelection(-1,null);
				LogCDrawUtils.setCurrentGraphType(graphType);	//needed for the title
				defaultPage = createDefaultPage(book);
				showPage(defaultPage);
				setViewTitle(mofObject);
				setLastMof(mofObject);
				putPage(mofObject,page,graphType);
				return;
			}
			makeActions();
		}
		
		putPage(mofObject,page,graphType);
		LogCDrawUtils.setWeightSelection(-1,null);
		LogCDrawUtils.setCurrentGraphType(graphType);
		if (page.isEmpty())
			showPage(defaultPage);
		else
			showPage(page);
        setViewTitle(mofObject);
		setLastMof(mofObject);  
		
		//update selection in view
		if (!page.isEmpty())
			((SDViewerPage)currentPage).getSdViewerUI().handleViewSelectionChangedEvent(null);
		return;
		
	}
	
	public void addLoadViewPage(EObject mofObject, int graphType, IConfigurationElement correlation) {
		if (!isValidForLoad(mofObject,graphType)) return;
		
		SDViewerPage page = (SDViewerPage) createPage(mofObject);
		page.createControl(book);
		LogCDrawUtils.setCurrentPage(page);
		page.loadModel(graphType,correlation);
		makeActions();
		putPage(mofObject, page, graphType);

		LogCDrawUtils.setWeightSelection(-1,null);
		LogCDrawUtils.setCurrentGraphType(graphType);
		showPage(page);
        setViewTitle(mofObject);
		setLastMof(mofObject);  
		
		//update selection in view
		((SDViewerPage)currentPage).getSdViewerUI().handleViewSelectionChangedEvent(null);
	}
	
	private boolean isAnyLogAgent(TRCAgentProxy agent)
	{
		if(!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE)
			&& !agent.getType().equals(HyadesConstants.J2EE_AGENT_NAME))
			return true;
		else
			return false;
	}
	
	private boolean isAnyLogAgent(TRCMonitor monitor)
	{
		EList nodes = monitor.getNodes();
		for(int idx=0; idx<nodes.size(); idx++)
		{
			TRCNode node = (TRCNode) nodes.get(idx);
			 if (isAnyLogAgent(node)) return true;
		}		
		return false;
	}
	
	private boolean isAnyLogAgent(TRCProcessProxy processProxy)
	{
		EList agents = processProxy.getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			 if (isAnyLogAgent((TRCAgentProxy) agents.get(idx))) return true;
		}		
		return false;
	}
	
	private boolean isAnyLogAgent(TRCNode node)
	{
		EList processes = node.getProcessProxies();
		for(int idx=0; idx<processes.size(); idx++)
		{
			 if (isAnyLogAgent((TRCProcessProxy) processes.get(idx))) return true;
		}	
		return false;
	}
	
	public boolean isValidObject(Object object)
	{
		return isValidObject(object, getCurrentGraphType());
	}
	/*
    * Returns true if the object can be viewed using this type of view 
    */
	private boolean isValidObject(Object object, int graphType)
	 {
		if(object == null)
		   return false;
 	  
	   if (graphType==Graph.LOGoverRECORD || graphType==Graph.THREADoverRECORD)
	   {
		 if (object instanceof CorrelationContainerProxy)
		 {	
			 for (Iterator iter = ((CorrelationContainerProxy)object).getCorrelatedAgents().iterator(); iter.hasNext();) {
				 TRCAgentProxy element = (TRCAgentProxy) iter.next();
				 if(isAnyLogAgent((TRCAgentProxy)element))
				 {
					 return true;
				 }
				
			 }
			 return false;
		 }else
		 if (object instanceof TRCAgentProxy)
			 return isAnyLogAgent((TRCAgentProxy)object);
		 else if (object instanceof TRCProcessProxy)
			 return isAnyLogAgent((TRCProcessProxy)object);
		 else if (object instanceof TRCNode)
			 return isAnyLogAgent((TRCNode)object);
		 else if (object instanceof TRCMonitor)
			 return isAnyLogAgent((TRCMonitor)object);
		 else
			 return false; 	  	
	   }
		return true;
	 }

	
	private String getExtendedTitle(int type){
	   
	   String title = null;
	   switch(type){
	   	  case(0):
	   	     break;
	   	  case(1):
	   	     title = SDPlugin.getString("STR_MENU_NOA");
	   	     setHelp("noad0000");
	   	     break;
	   	  case(2):
	   	     title = SDPlugin.getString("STR_MENU_NOP");
	   	     setHelp("nopd0000");
	   	     break;
	   	  case(3):
	   	     title = SDPlugin.getString("STR_MENU_AOP");
	   	     setHelp("aopd0000");
	   	     break;
	   	  case(4):
	   	     title = SDPlugin.getString("STR_MENU_NOT");
	   	     setHelp("notd0000");
	   	     break;
	   	  case(5):
	   	     title = SDPlugin.getString("STR_MENU_AOT");
	   	     setHelp("aotd0000");
	   	     break;
	   	  case(6):
	   	     title = SDPlugin.getString("STR_MENU_POT");
	   	     setHelp("potd0000");
	   	     break;
	   	  case(7):
	   	     title = SDPlugin.getString("STR_MENU_NOO");
	   	     setHelp("nooad0000");
	   	     break;
	   	  case(8):
	   	     title = SDPlugin.getString("STR_MENU_AOO");
	   	     setHelp("aood0000");
	   	     break;
	   	  case(9):
	   	     title = SDPlugin.getString("STR_MENU_POO");
	   	     setHelp("pood0000");
	   	     break;
	   	  case(10):
	   	     title = SDPlugin.getString("STR_MENU_TOO");
	   	     setHelp("tood0000");
	   	     break;
	   	  case(11):
	   	     title = SDPlugin.getString("STR_MENU_NOC");
	   	     setHelp("nocd0000");
	   	     break;
	   	  case(12):
	   	     title = SDPlugin.getString("STR_MENU_AOC");
	   	     setHelp("aocd0000");
	   	     break;
	   	  case(13):
	   	     title = SDPlugin.getString("STR_MENU_POC");
	   	     setHelp("pocd0000");
	   	     break;
	   	  case(14):
	   	     title = SDPlugin.getString("STR_MENU_TOC");
	   	     setHelp("tocd0000");
	   	     break;
	   	  case(15):
	   	     title = SDPlugin.getString("STR_MENU_NOM");
	   	     setHelp("nomd0000");
	   	     break;
	   	  case(16):
	   	     title = SDPlugin.getString("STR_MENU_OOM");
	   	     setHelp("oomd0000");
	   	     break;
	   	  case(17):
	   	     title = SDPlugin.getString("STR_MENU_COM");
	   	     setHelp("comd0000");
	   	     break;
	   	  case(18):
	   	     title = SDPlugin.getString("STR_MENU_TOM");
	   	     setHelp("tomd0000");
	   	     break;
	   	  case(19):
	   	     title = SDPlugin.getString("STR_MENU_POM");
	   	     setHelp("pomd0000");
	   	     break;
	   	  case(20):
	   	     title = SDPlugin.getString("STR_MENU_AOM");
	   	     setHelp("aomd0000");
	   	     break;
          case(21):
	   	     title = SDPlugin.getString("STR_MENU_LOR");
	   	     //setHelp("aomd0000");
	   	     break;
		  case(22):
			 title = SDPlugin.getString("STR_MENU_LOT");   
	   	     
	   	  default:
	   	     break;    
	   }
	   title = ": "+title;
	   return title;	
	}
	
	private void setHelp(String contextID)
	{
		if(_parent!=null)
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_parent,
			SDPlugin.getPluginId() + "."+contextID);
	}

	public TraceViewerPage createPage(EObject mofObject) {
		return new SDViewerPage(mofObject, this);
	}

	public void createPartControl(Composite parent) {
		book = new PageBook(parent, SWT.NONE);
		UIPlugin.getDefault().addProfileEventListener(this);	
		UIPlugin.getDefault().addSelectionListener(this);
		UIPlugin.getDefault().addDeleteListener(this);
		
		EObject mofObject = HyadesUtil.getMofObject();
        if(mofObject!=null){
        	if (getCurrentGraphType()!=Graph.LOGoverRECORD
        		&& getCurrentGraphType()!=Graph.THREADoverRECORD)
 	  		{
 	  			//there is no need to load for log interaction as correlation dialog will have to prompt first
 				addLoadViewPage(mofObject, getCurrentGraphType(),false);
 	  		}
           IPage page = getPage(mofObject, getCurrentGraphType());
           if (page!=null)
				_parent=page.getControl().getParent();
		  
           else
           	{
				defaultPage = createDefaultPage(book);
			   	showPage(defaultPage);
		   		_parent = parent;
           	}
		}else{
			defaultPage = createDefaultPage(book);
		   showPage(defaultPage);
		   _parent = parent;
        }
        
		getViewSite().getPage().addPartListener(fPartListener);	 
		//setSettings(UIPlugin.getDefault().getDialogSettings().getSection(PDProjectExplorer.TRACE_SECTION));
	}
		
	public IPage getCurrentPage() {
		return currentPage;
	}

	public SDViewerPage getPage(Object mofObject, int graphType) {
		if (mofObject != null)
		{
			Object pageData = _pages.get(mofObject);
			if (pageData != null)
			{
				Object page = ((HashMap)pageData).get(String.valueOf(graphType));			
				return (SDViewerPage) page;
			}
		}
		

		return null;
	}
	
	
	protected void putPage(EObject mofObject, SDViewerPage page, int graphType)
	{
		if ((graphType==Graph.LOGoverRECORD || graphType==Graph.THREADoverRECORD)
			&& page.getCorrelationType()==null) 
			return; 
			
		if (mofObject == null) return;
		 
		Object pageData = _pages.get(mofObject);
		if(pageData == null)
		{
		   pageData = new HashMap();
		   _pages.put(mofObject, pageData);
		}
		   
		HashMap data = (HashMap)pageData;
		data.put(String.valueOf(graphType), page);						
	}

	public void initializedMenu(boolean init) {
		_initializedMenu = init;
	}

	public boolean isInitializedMenu() {
		return _initializedMenu;
	}

	public void makeActions() {
		if (isInitializedMenu())
			return; //create the toolbar only once

		initializedMenu(true);
		
		//refresh - not included in action bar
		if (STR_REFRESH == null)
			STR_REFRESH = SDPlugin.getString("STR_REFRESH_SD_VIEW");
		refresh = new RefreshAction(STR_REFRESH);
		refresh.setText(STR_REFRESH);
		SDPluginImages.setImageDescriptors(refresh,SDPluginImages.T_LCL,SDPluginImages.IMG_REFRESH_VIEWS);
		refresh.setDescription(STR_REFRESH);
		refresh.setToolTipText(STR_REFRESH);

		//find		
		if (STR_FIND == null) 
			STR_FIND = SDPlugin.getString("STR_FIND");
		find = new FindAction(STR_FIND);
		find.setText(STR_FIND);
		SDPluginImages.setImageDescriptors(find,SDPluginImages.T_TOOL,SDPluginImages.IMG_SEARCH);
		find.setDescription(STR_FIND);
		find.setToolTipText(STR_FIND);
		
		//zoom_in
		if (STR_ZOOM_IN == null)
			 STR_ZOOM_IN =SDPlugin.getString("STR_ZOOMIN");
		zoomIn = new ZoomInAction(STR_ZOOM_IN);
		zoomIn.setText(STR_ZOOM_IN);
		SDPluginImages.setImageDescriptors(zoomIn,SDPluginImages.T_LCL,SDPluginImages.IMG_ZOOM_IN);
		zoomIn.setDescription(STR_ZOOM_IN);
		zoomIn.setToolTipText(STR_ZOOM_IN);
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			zoomIn,
			SDPlugin.getPluginId() + ".zmin0000");

		//zoom_out
		if (STR_ZOOM_OUT == null)
			STR_ZOOM_OUT = SDPlugin.getString("STR_ZOOMOUT");
		zoomOut = new ZoomOutAction(STR_ZOOM_OUT);
		zoomOut.setText(STR_ZOOM_OUT);
		SDPluginImages.setImageDescriptors(zoomOut,SDPluginImages.T_LCL,SDPluginImages.IMG_ZOOM_OUT);		
		zoomOut.setDescription(STR_ZOOM_OUT);
		zoomOut.setToolTipText(STR_ZOOM_OUT);
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			zoomOut,
			SDPlugin.getPluginId() + ".zmot0000");

        //home		
		if (STR_HOME == null) 
			STR_HOME = SDPlugin.getString("STR_HOME");
		home = new HomeAction(STR_HOME);
		home.setText(STR_HOME);
		SDPluginImages.setImageDescriptors(home,SDPluginImages.T_TOOL,SDPluginImages.IMG_HOME);	
		home.setDescription(STR_HOME);
		home.setToolTipText(STR_HOME);
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			home,
			SDPlugin.getPluginId() + ".home0000");

		IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
		tbm.add(new Separator());
		tbm.add(find);
		tbm.add(zoomIn);
		tbm.add(zoomOut);
		tbm.add(home);
		tbm.add(new Separator());
		
		//since both TABLE and SD views share the same viewer, the toolbar 
		//buttons need to be enabled/disabled accordingly
		boolean actionEnable = false;
		if(LogCDrawUtils.getViewerType()==LogCDrawUtils.TABLE_VIEWER)
		   actionEnable = false;
		else if(LogCDrawUtils.getViewerType()==LogCDrawUtils.SD_VIEWER)
		   actionEnable = true;
		zoomIn.setEnabled(actionEnable);
		zoomOut.setEnabled(actionEnable);
		home.setEnabled(actionEnable);
		// require update because toolbar control has been created by this point,
		// but manager does not update it automatically once it has been created
		getViewSite().getActionBars().updateActionBars();
	}

	public void setFocus() {
		if (currentPage instanceof SDViewerPage){
		    Composite editorUI = (Composite)currentPage.getControl();
		    if(!editorUI.isDisposed())
		       editorUI.setFocus();
		}
	}


	public void showPage(IPage page) {
		if (currentPage!=null && !(currentPage instanceof DefaultPage ))
		{
			((SDViewerPage)currentPage).getSdViewerUI().removeViewSelectionChangedListener();
		}
		if(page!=null && book!=null){
		   book.showPage(page.getControl());
		   currentPage = page;
		   if (currentPage!=null && !(currentPage instanceof DefaultPage ))
		   {
		   		((SDViewerPage)currentPage).getSdViewerUI().addViewSelectionChangedListener();
		   }
		}
	}
	
	public int getCurrentGraphType(){
	   return LogCDrawUtils.getCurrentGraphType();	
	}

	public void disposeBook(){

		if (book != null)
		{
			
			if (!book.isDisposed()) 
			{
				book.dispose();
			} 
			book = null;
		}
		
		
	}
   public void dispose(){
   		
	  UIPlugin.getDefault().removeProfileEventListener(this);				
	  UIPlugin.getDefault().removeSelectionListener(this);
	  UIPlugin.getDefault().removeDeleteListener(this);
	  getSite().getPage().removePartListener(fPartListener);
	  super.dispose();
	
	  disposeMyData();
	  defaultPage = null;
	  disposeBook();
	  zoomIn = null;
	  zoomOut = null;
	  refresh = null;
	  home = null;
	  find = null;
	  LogCDrawUtils.reset();
	  
   }
   

	private void disposeMyData()
	{
		Enumeration pages = _pages.elements();  
		   while(pages.hasMoreElements()){
			  HashMap pageMap = (HashMap) pages.nextElement();
			  Page page ;
			  for(int i = 0; i<23; i++){//go through all the graph types
				 if(pageMap.containsKey(String.valueOf(i))){
					page = (Page) pageMap.get(String.valueOf(i));
					if(page instanceof SDViewerPage)
					{
						((SDViewerPage)page).dispose();
						
						
					
					}
				 }
			  }
		   }
			  
			_pages.clear();
			currentPage = null;
			lastMofNode = null;

	}

     	

   public EObject getObjectToView(EObject selObject) {
   	   if (lastMofType==-1 || selObject==null) return selObject;
   	
	   if ((selObject instanceof TRCAgentProxy) && (((TRCAgentProxy)selObject).getProcessProxy()!=null) && (lastMofNode == ((TRCAgentProxy)selObject).getProcessProxy().getNode()))
	   {
			if (lastMofType == 0) {
				return selObject;
				
			} else if (lastMofType == 1
					&& ((TRCProcessProxy) lastSelection).getAgentProxies().size()== 1
					&& ((TRCProcessProxy) lastSelection)==((TRCAgentProxy)selObject).getProcessProxy()) {
				return (TRCProcessProxy)lastSelection;
				
			} else if (lastMofType == 2) {
				EList agents = LogCDrawUtils.getAgentProxies((TRCNode) lastSelection);
				if (agents.size() == 1 && agents.iterator().next() == (TRCAgentProxy) selObject)
					return (TRCNode)lastSelection;
			}
			return selObject;
	   }
	   else if (selObject instanceof TRCProcessProxy && lastMofNode == ((TRCProcessProxy) selObject).getNode())
	   {
	   		if (lastMofType == 0
	   				&& ((TRCProcessProxy)selObject).getAgentProxies().size()==1
	   				&& (((TRCProcessProxy)selObject).getAgentProxies().iterator().next()==(TRCAgentProxy)lastSelection)) {
	   			return (TRCAgentProxy)lastSelection;
	   			
	   		} else if (lastMofType == 1) {
	   			return selObject;
	   			
	   		} else if (lastMofType == 2
	   				&& ((TRCNode)lastSelection).getProcessProxies().size()==1
	   				&& ((TRCNode)lastSelection).getProcessProxies().iterator().next()==(TRCProcessProxy)selObject) {
	   			return (TRCNode)lastSelection;
	   		}	   	
	   }
	   else if (selObject instanceof TRCNode && lastMofNode == (TRCNode)selObject)
	   {
	   		if (lastMofType == 0){
				EList agents = LogCDrawUtils.getAgentProxies((TRCNode)selObject);
				if (agents.size() == 1 && agents.iterator().next() == (TRCAgentProxy)lastSelection)
					return (TRCAgentProxy)lastSelection;
	   		
	   		} else if (lastMofType == 1
					&& ((TRCNode)selObject).getProcessProxies().size()==1
					&& ((TRCNode)selObject).getProcessProxies().iterator().next()==(TRCProcessProxy)lastSelection) {
				return (TRCProcessProxy)lastSelection;	   			
	   			
	   		} else if (lastMofType == 2) {
	   			return selObject;
	   		}
	   }
	   return selObject;
   }

   private void setLastMof(EObject obj){
		   if(obj instanceof TRCAgentProxy){
		     lastMofNode = ((TRCAgentProxy)obj).getProcessProxy().getNode();
		     lastSelection = ((TRCAgentProxy)obj);
			 lastMofType=0;
		   }else if(obj instanceof TRCProcessProxy){
		     lastMofNode = ((TRCProcessProxy)obj).getNode();
		     lastSelection = ((TRCProcessProxy)obj);
			 lastMofType=1;
		   }else if(obj instanceof TRCNode){
		     lastMofNode = (TRCNode)obj;
		     lastSelection = (TRCNode)obj;
		     lastMofType=2;
		   }
		   else {
		   	  lastMofNode = null;
		   	  lastSelection = null;
		   	  lastMofType = -1;
		   }
   }

   protected void refreshPage(Object obj) {
	  Object page = getPage(obj, getCurrentGraphType());

	  if (page != null && page instanceof SDViewerPage) {
	  	 	LogCDrawUtils.setCurrentPage((SDViewerPage) page);
	     	((SDViewerPage) page).loadModel(getCurrentGraphType(),false);
			if (((SDViewerPage)page).isEmpty()) {
		   		showPage(defaultPage);
	   		}
	   		else {
		   		showPage((SDViewerPage) page);
			}
			((SDViewerPage) page).getSdViewerUI().handleViewSelectionChangedEvent(null);
	  }
	  
	  setViewTitle(obj);
   }

   public void setViewTitle(Object selection){
//	  if(selection != null
//	  		&& selection instanceof TRCAgentProxy 
//			&& getCurrentGraphType()!=Graph.LOGoverRECORD 
//			&& getCurrentGraphType()!=Graph.THREADoverRECORD){
//			
//			  TRCAgentProxy a = (TRCAgentProxy)selection;			
//			  String status = TString.getAgentLabel(a);
//			  
//			  setTitle(getViewTitle() + " [" + status+" "+TString.getProcessName(a.getProcessProxy())+"]");
//			  return;
//			
//	 }
	 displaySelection=selection;
	 setTitle(getViewTitle()); 		
   }

   /*
    * Initial view title
    */
    public String getViewTitle(){	
    	String correlationType = "";
    	
    	if ((getCurrentGraphType()==Graph.LOGoverRECORD || getCurrentGraphType()==Graph.THREADoverRECORD) && !(getCurrentPage() instanceof DefaultPage) )
    	{
		 if (displaySelection!=null && displaySelection instanceof CorrelationContainerProxy)
				correlationType = " <" + ((CorrelationContainerProxy)displaySelection).getCorrelationEngine().getName() + ">";
		 else
			correlationType = " <" + LogCDrawUtils.getCorrelationName(((SDViewerPage)getCurrentPage()).getCorrelationType())+ ">";
    	}
       return SDPlugin.getString("STR_VIEW_TITLE") + 
       				getExtendedTitle(getCurrentGraphType()) + correlationType;
					
    }
 
    public void deregister(Object obj){
    	
    	disposeMyData();
		defaultPage = createDefaultPage(book);
		showPage(defaultPage);
		
		
    }

 
 	public GraphNode getNodeByRecord(CBECommonBaseEvent logViewRecord)
 	{
 		IPage page = getCurrentPage();
 		if (page!=null && !(page instanceof DefaultPage))
 		{
 			GraphNode[] tops = ((SDViewerPage)page).getSdViewerUI().getColumnFigures();
 			for (int i=0;i<tops.length;i++)
 			{
 				if (tops[i]!=null)
 				{
					GraphNode[] nodes =
						((NodeContainer) tops[i]).getInternalNodes();
					for (int j = 0; j < nodes.length; j++) {
						if (nodes[j]!=null && nodes[j].getUserArea()!=null)
						{
							Object obj = ((GraphNode) nodes[j]).getUserArea();
							if (obj instanceof CBECommonBaseEvent) {
								if ( ((CBECommonBaseEvent) obj).getGlobalInstanceId() != null
									 && logViewRecord.getGlobalInstanceId() != null
								     && ((CBECommonBaseEvent) obj).getGlobalInstanceId().equals(logViewRecord.getGlobalInstanceId()))

								{
									return ((GraphNode) nodes[j]);
								}
							}
						}
					}
 				}
 			}
 		}
 		return null;
 	}
 	
}
