/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.formatter;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.formatter.FormatterType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FormatterTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public final static String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_FMT_DESCR");
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FormatterTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDescriptionPropertyDescriptor(object);
			addDummyAttr1PropertyDescriptor(object);
			addDummyAttr2PropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_FMT_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_FMT_DESCR", "_UI_FormatterType_type"),
				 FormatterPackage.eINSTANCE.getFormatterType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Dummy Attr1 feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDummyAttr1PropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_FormatterType_dummyAttr1_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_FormatterType_dummyAttr1_feature", "_UI_FormatterType_type"),
				 FormatterPackage.eINSTANCE.getFormatterType_DummyAttr1(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Dummy Attr2 feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDummyAttr2PropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_FormatterType_dummyAttr2_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_FormatterType_dummyAttr2_feature", "_UI_FormatterType_type"),
				 FormatterPackage.eINSTANCE.getFormatterType_DummyAttr2(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_FMT_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_FMT_ID", "_UI_FormatterType_type"),
				 FormatterPackage.eINSTANCE.getFormatterType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}


	/**
	 * This returns FormatterType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_FORMATTER);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((FormatterType)object).getUniqueID();
		return label == null || label.length() == 0 ?
			getString("_UI_FormatterType_type") :
			getString("_UI_FormatterType_type") + " [" + label + "]";
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(FormatterType.class)) {
			case FormatterPackage.FORMATTER_TYPE__DESCRIPTION:
			case FormatterPackage.FORMATTER_TYPE__DUMMY_ATTR1:
			case FormatterPackage.FORMATTER_TYPE__DUMMY_ATTR2:
			case FormatterPackage.FORMATTER_TYPE__UNIQUE_ID: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(owner);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}	
}
