/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.*;
import org.eclipse.hyades.logging.adapter.model.internal.context.*;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.Extractor;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.*;
import org.eclipse.hyades.logging.adapter.model.internal.parser.*;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.ui.internal.configuration.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.util.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.*;

public class DetailsContent extends Composite {

	protected EditingDomain editingDomain;	
	protected StackLayout detailsLayout;
	protected Composite details;
	protected RuleBuilderWidgetFactory widgetFactory;
	protected ConfigurationItemProviderAdapterFactory factory;
	
	protected ComponentConfigSection compSection;
	protected ContextInstanceSection contextInstanceSection;
	protected ExtractorSection       extractorSection;	
	protected ParserSection          parserSection;		
	protected RuleSection            ruleSection;
	protected ProcessUnitSection     unitSection;	
	protected SensorSection          sensorSection;	
	protected SingleFileSensorSection  singleFileSensorSection;		
	protected StaticParserSection     staticParserSection;	
	protected SensorPropertySection  sensorPropertySection;	
	protected OutputterSection       outputterSection;	
	protected SingleFileOutputterSection  singleFileOutputterSection;		
	protected LoggingOutputterSection  logOutputterSection;
	protected InfoSection            infoDetails;
	protected ContextSection         contextSection;
	protected ComponentSection       componentSection;
	protected RuleAttributeSection   attrSection;
	protected RuleElementSection     elemSection;
	protected FormatterSection       formatterSection;
	

	/**
	 * Constructor for DetailsContent.
	 */
	public DetailsContent(RuleBuilderWidgetFactory widgetFactory, EditingDomain editingDomain, ConfigurationItemProviderAdapterFactory factory, Composite composite, int style) {
		super(composite, style);
		this.widgetFactory = widgetFactory;
		this.factory = factory;		
		this.editingDomain = editingDomain;
	}
	
	public Composite createContent(){
		
		detailsLayout = new StackLayout();
	    this.setLayout(detailsLayout);
	    GridData detailsGrid = new GridData(GridData.FILL_BOTH);
	    detailsGrid.horizontalIndent = 10;
	    this.setLayoutData(detailsGrid);
	    
	    compSection = new ComponentConfigSection(widgetFactory, this, SWT.NONE);
	    contextInstanceSection = new ContextInstanceSection(widgetFactory, this, SWT.NONE);
		extractorSection = new ExtractorSection(widgetFactory, this, SWT.NONE);	
		parserSection = new ParserSection(widgetFactory, this, SWT.NONE);	    
		ruleSection = new RuleSection(widgetFactory, this, SWT.NONE);
		unitSection = new ProcessUnitSection(widgetFactory, this, SWT.NONE);
		sensorSection = new SensorSection(widgetFactory, this, SWT.NONE);	
		singleFileSensorSection = new SingleFileSensorSection(widgetFactory, this, SWT.NONE);
		staticParserSection = new StaticParserSection(widgetFactory, this, SWT.NONE);			
		outputterSection = new OutputterSection(widgetFactory, this, SWT.NONE);
		singleFileOutputterSection = new SingleFileOutputterSection(widgetFactory, this, SWT.NONE);
		sensorPropertySection = new SensorPropertySection(widgetFactory, this, SWT.NONE);		
		logOutputterSection = new LoggingOutputterSection(widgetFactory, this, SWT.NONE);
		infoDetails = new InfoSection(widgetFactory, this, SWT.NONE);
		contextSection = new ContextSection(widgetFactory, editingDomain, this, SWT.NONE);
		componentSection = new ComponentSection(widgetFactory, editingDomain, this, SWT.NONE);
		attrSection = new RuleAttributeSection(widgetFactory, this, SWT.NONE);
		elemSection = new RuleElementSection(widgetFactory, this, SWT.NONE);
		formatterSection = new FormatterSection(widgetFactory, this, SWT.NONE);
	    
        hideDetails();
        return details;				
	}

   /**
    * 
    * @param data
    */
   public void showDetailsFor(EObject data){

		if(data instanceof Configuration)
			showDetail(compSection, data);  
		else if(data instanceof ContextType)
			showDetail(contextSection, data);  			
		else if(data instanceof ContextInstanceType)
			showDetail(contextInstanceSection, data);  
		else if(data instanceof SensorConfigType)
			showDetail(sensorSection, data);   
		else if(data instanceof SingleFileSensorType)
			showDetail(singleFileSensorSection, data);  
		else if(data instanceof StaticParserSensorType)
			showDetail(staticParserSection, data);   			
		else if(data instanceof Extractor)
			showDetail(extractorSection, data); 
		else if(data instanceof ParserConfigType)
			showDetail(parserSection, data);   			
   		else if(data instanceof SubstitutionRuleType)
   			showDetail(ruleSection, data); 
		else if(data instanceof ProcessUnitType)
			showDetail(unitSection, data);  
		else if(data instanceof OutputterConfigType)
			showDetail(outputterSection, data);   
		else if(data instanceof SingleFileOutputterType)
			showDetail(singleFileOutputterSection, data); 
		else if(data instanceof LoggingAgentOutputterType)
			showDetail(logOutputterSection, data);
		else if(data instanceof Component)
			showDetail(componentSection, data);
		else if(data instanceof RuleAttributeType)
			showDetail(attrSection, data);
		else if(data instanceof RuleElementType)
			showDetail(elemSection, data);
		else if(data instanceof FormatterType)
			showDetail(formatterSection, data);
		else if(data instanceof SensorPropertyType)
			showDetail(sensorPropertySection, data);
			
   		else
   		   showDetail(infoDetails, data);	 					
   };
   
   public void setFocusFor(Object object){
   		
   		if(object instanceof Configuration)
   		   compSection.setFocusToText();
		else if(object instanceof ContextType)
		   contextSection.setFocusToText();   		   
   		else if(object instanceof ContextInstanceType)
   		    contextInstanceSection.setFocusToText();  
		else if(object instanceof SensorConfigType)
			sensorSection.setFocusToText();   
		else if(object instanceof SingleFileSensorType)
			singleFileSensorSection.setFocusToText();  
		else if(object instanceof StaticParserSensorType)
			staticParserSection.setFocusToText();     		    
		else if(object instanceof Extractor)
			extractorSection.setFocusToText(); 
		else if(object instanceof ParserConfigType)
			parserSection.setFocusToText();   
   		else if(object instanceof SubstitutionRuleType)
   			 ruleSection.setFocusToText();
		else if(object instanceof ProcessUnitType)
			 unitSection.setFocusToText();
		else if(object instanceof OutputterConfigType)
			 outputterSection.setFocusToText();
		else if(object instanceof SingleFileOutputterType)
			 singleFileOutputterSection.setFocusToText();
		else if(object instanceof LoggingAgentOutputterType)
			 logOutputterSection.setFocusToText();
		else if(object instanceof Component)
			 componentSection.setFocusToText();
		else if(object instanceof RuleAttributeType)
			 attrSection.setFocusToText();
		else if(object instanceof RuleElementType)
			 elemSection.setFocusToText();
		else if(object instanceof FormatterType)
			 formatterSection.setFocusToText();
		else if(object instanceof SensorPropertyType)
			 sensorPropertySection.setFocusToText();
			 
    }
   
   private void hideDetails(){
   	
   	    compSection.setVisible(false);
   	    contextInstanceSection.setVisible(false);
   	    sensorSection.setVisible(false);
   	    extractorSection.setVisible(false);
   	    parserSection.setVisible(false);
		ruleSection.setVisible(false);	
		unitSection.setVisible(false);	
		outputterSection.setVisible(false);	
		singleFileSensorSection.setVisible(false);
		staticParserSection.setVisible(false);		
		singleFileOutputterSection.setVisible(false);
		logOutputterSection.setVisible(false);
		infoDetails.setVisible(false);
		contextSection.setVisible(false);
		componentSection.setVisible(false);
		attrSection.setVisible(false);
		elemSection.setVisible(false);
		formatterSection.setVisible(false);
		sensorPropertySection.setVisible(false);
		
   }
   
   private void showDetail(Control detail, EObject data){
   		((IDetails)detail).display(data);
   		detailsLayout.topControl = (Control)detail;
   		layout();
   }
 
   public void dispose() {
   	
   		factory = null;
   		widgetFactory = null;
   		editingDomain = null;
   		
   		if(infoDetails != null)
   		  infoDetails.dispose();
		if(ruleSection != null)
		  ruleSection.dispose();
		if(compSection != null)
		  compSection.dispose();
		if(contextInstanceSection != null)
		  contextInstanceSection.dispose(); 
		if(extractorSection != null)
		    extractorSection.dispose();  
		if(unitSection != null)
		   unitSection.dispose();       
		if(sensorSection != null)
		   sensorSection.dispose();       
		if(outputterSection != null)
		   outputterSection.dispose();
		if(singleFileSensorSection != null)
		   singleFileSensorSection.dispose();
		if(staticParserSection != null)
		   staticParserSection.dispose();  
		if(singleFileOutputterSection != null)
		  singleFileOutputterSection.dispose();  
		if(logOutputterSection != null)
		  logOutputterSection.dispose();      
		if(parserSection != null)
		  parserSection.dispose(); 
		if(contextSection != null)
		  contextSection.dispose(); 
		if(componentSection != null)
		  componentSection.dispose(); 
		if(attrSection != null)
		  attrSection.dispose();      
		if(elemSection != null)
		  elemSection.dispose();      
		if(formatterSection != null)
		  formatterSection.dispose();   
		if(sensorPropertySection != null)
		  sensorPropertySection.dispose();     

   }

}
