/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.unit;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.unit.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.unit.ProcessUnitType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ProcessUnitTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_PU_DESCR");
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessUnitTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDescriptionPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_PU_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_PU_DESCR", "_UI_ProcessUnitType_type"),
				 UnitPackage.eINSTANCE.getProcessUnitType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_PU_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_PU_ID", "_UI_ProcessUnitType_type"),
				 UnitPackage.eINSTANCE.getProcessUnitType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}


	/**
	 * This returns ProcessUnitType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PROCESS_UNIT);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((ProcessUnitType)object).getUniqueID();
		return label == null || label.length() == 0 ?
			getString("_UI_ProcessUnitType_type") :
			getString("_UI_ProcessUnitType_type") + " [" + label + "]";
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(ProcessUnitType.class)) {
			case UnitPackage.PROCESS_UNIT_TYPE__DESCRIPTION:
			case UnitPackage.PROCESS_UNIT_TYPE__UNIQUE_ID: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
	
}
