/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.formatter.*;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class FormatterSection extends Composite
								implements IDetails, ModifyListener
										   , INotifyChangedListener
{
	protected Text descriptionText;			
	protected Label uniqueId;
	
    protected boolean isDisplaying;
    protected FormatterType currentSelection;
    protected FormatterTypeItemProvider itemProvider;
    protected FormatterItemProviderAdapterFactory itemFactory;
	
	
	public FormatterSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new FormatterItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
				
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_FMT_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.MULTI);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_FMT_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "");
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		descriptionText.addModifyListener(this);
		
		itemProvider = (FormatterTypeItemProvider)itemFactory.createFormatterAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
      
		if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)object.eContainer());

		if(currentSelection == object)
		  return;
        
		if(descriptionText.isFocusControl() || uniqueId.isFocusControl())		   
		  return;
        
		currentSelection = (FormatterType)object;
		isDisplaying = true;
			
		descriptionText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		uniqueId.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (FormatterType)currentSelection;
		
		this.currentSelection.setDescription(descriptionText.getText());
		
		return false;

	}
	
	public void setFocusToText(){
	        descriptionText.setFocus();
	        descriptionText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						FormatterTypeItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

}
