/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.*;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.*;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.adapter.AdapterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.configuration.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.context.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.extractor.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.formatter.FormatterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.outputter.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.parser.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.sensor.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.unit.UnitItemProviderAdapterFactory;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.SelectionDialog;

/**
 * @author popescu
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ResourceSelectionDialog extends SelectionDialog {

   protected EditingDomain editingDomain;
   protected Object selection;
   
	/**
	 * @param parentShell
	 */
	public ResourceSelectionDialog(Shell parentShell, EditingDomain editingDomain) {
		super(parentShell);
		
		setTitle(AcadEditorPlugin.getPlugin().getString("STR_SELC_DLG_TITLE"));
		this.editingDomain = editingDomain;
	}

	protected Control createDialogArea(Composite parent) {
	  // create composite 
	  Composite dialogArea = (Composite)super.createDialogArea(parent);
	  GridData data = GridUtil.createFill();
	  data.widthHint = 300;
	  data.heightHint = 400;
	  dialogArea.setLayoutData(data);
	  dialogArea.setLayout(new GridLayout());
	  
	  Tree tree = new Tree(dialogArea, SWT.SINGLE|SWT.BORDER);
	  tree.setLayoutData(GridUtil.createFill());
	  final TreeViewer selectionViewer = new TreeViewer(tree);
	  
	  List factories = new ArrayList();
	  factories.add(new ResourceItemProviderAdapterFactory());
	  factories.add(new ConfigurationItemProviderAdapterFactory());
	  factories.add(new ExtractorItemProviderAdapterFactory());
	  factories.add(new ContextItemProviderAdapterFactory());
	  factories.add(new OutputterItemProviderAdapterFactory());
	  factories.add(new SensorItemProviderAdapterFactory());
	  factories.add(new AdapterItemProviderAdapterFactory());
	  factories.add(new ParserItemProviderAdapterFactory());
	  factories.add(new FormatterItemProviderAdapterFactory());
	  factories.add(new UnitItemProviderAdapterFactory());

	  ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
	  
	  selectionViewer.setContentProvider(new AdapterFactoryContentProvider(adapterFactory));
	  selectionViewer.setLabelProvider(new AdapterFactoryLabelProvider(adapterFactory));
	  
	  EList list = editingDomain.getResourceSet().getResources();
	  if(list.size() > 0)
		  selectionViewer.setInput(list.get(0));		   
	  else
		  selectionViewer.setInput(editingDomain.getResourceSet());
	  
		selectionViewer.addSelectionChangedListener(
			new ISelectionChangedListener() {
				public void selectionChanged(SelectionChangedEvent event) {
					IStructuredSelection selection = (IStructuredSelection)event.getSelection();
					setSelection(selection.getFirstElement()); // allow null
				}
			});
		selectionViewer.addDoubleClickListener(
			new IDoubleClickListener() {
				public void doubleClick(DoubleClickEvent event) {
					ISelection selection = event.getSelection();
					if (selection instanceof IStructuredSelection) {
						Object item = ((IStructuredSelection)selection).getFirstElement();
						if (selectionViewer.getExpandedState(item))
						selectionViewer.collapseToLevel(item, 1);
						else
						selectionViewer.expandToLevel(item, 1);
					}
				}
			});
	  
	  return dialogArea;
	}

/**
 * @return
 */
public Object getSelection() {
	return selection;
}

/**
 * @param object
 */
public void setSelection(Object object) {
	selection = object;
}

}
