/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.parser.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class RuleSection extends Composite
								implements IDetails, ModifyListener, SelectionListener
										   , INotifyChangedListener
{
	protected Text matchText;
	protected Text positionsText;
	protected Text substituteText;	
	protected Button useBuiltInFunction;
    protected boolean isDisplaying;
    protected SubstitutionRuleType currentSelection;
    protected SubstitutionRuleTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory;
	
	
	public RuleSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		itemFactory = new ParserItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_MATCH"), SWT.NONE);	
		matchText = factory.createText(this, "", SWT.NULL);
		matchText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_POS"), SWT.NONE);	
		positionsText = factory.createText(this, "", SWT.NULL);
		positionsText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_SUBST"), SWT.NONE);	
		substituteText = factory.createText(this, "", SWT.NULL);
		substituteText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
		
		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		useBuiltInFunction = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("_SUBST_USE_BUILT_FCT"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);				
		useBuiltInFunction.setLayoutData(data);		
			
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		positionsText.addModifyListener(this);
		matchText.addModifyListener(this);
		substituteText.addModifyListener(this);
		useBuiltInFunction.addSelectionListener(this);
		
		itemProvider = (SubstitutionRuleTypeItemProvider)itemFactory.createSubstitutionRuleTypeAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
        
		if(currentSelection == object)
		  return;
        
		if(positionsText.isFocusControl() || matchText.isFocusControl()
		   || substituteText.isFocusControl() || useBuiltInFunction.isFocusControl())		   
		  return;
        
		currentSelection = (SubstitutionRuleType)object;
		isDisplaying = true;
			
		matchText.setText(currentSelection.getMatch()==null?"":currentSelection.getMatch());
		positionsText.setText(currentSelection.getPositions()==null?"":currentSelection.getPositions());
		substituteText.setText(currentSelection.getSubstitute()==null?"":currentSelection.getSubstitute());
		useBuiltInFunction.setSelection(currentSelection.isUseBuiltInFunction());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (SubstitutionRuleType)currentSelection;
		
		this.currentSelection.setPositions(positionsText.getText());
		this.currentSelection.setMatch(matchText.getText());
		this.currentSelection.setSubstitute(substituteText.getText());
		this.currentSelection.setUseBuiltInFunction(useBuiltInFunction.getSelection());
		
		return false;

	}
	
	public void setFocusToText(){
	        substituteText.setFocus();
	        substituteText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == matchText)
		{
			String text = matchText.getText();
			if(!text.equals(currentSelection.getMatch()))
			{
				if(text.length() == 0 && currentSelection.getMatch() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						SubstitutionRuleTypeItemProvider.MATCH);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}		  
		else if(e.getSource() == positionsText)
		{
			String text = positionsText.getText();
			if(!text.equals(currentSelection.getPositions()))
			{
				if(text.length() == 0 && currentSelection.getPositions() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						SubstitutionRuleTypeItemProvider.POSITIONS);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		else if(e.getSource() == substituteText)
		{
			String text = substituteText.getText();
			if(!text.equals(currentSelection.getSubstitute()))
			{
				if(text.length() == 0 && currentSelection.getSubstitute() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						SubstitutionRuleTypeItemProvider.SUBSTITUTE);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}				
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	public void widgetSelected(SelectionEvent e)
	{
		IItemPropertyDescriptor descriptor = 
			itemProvider.getPropertyDescriptor(
				currentSelection,
				SubstitutionRuleTypeItemProvider.MATCH);
		
		currentSelection.setUseBuiltInFunction(useBuiltInFunction.getSelection());		
		String oldValue = currentSelection.getMatch();		
		if(descriptor != null)
		{
			descriptor.setPropertyValue(currentSelection, oldValue);										
		}	
	}
	
	public void widgetDefaultSelected(SelectionEvent e)
	{
	}	

}
