/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.io.File;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.sensor.*;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class StaticParserSection extends Composite
								implements IDetails, ModifyListener, SelectionListener
										   , INotifyChangedListener
{
	protected Text directoryText;	
	protected Button browseDirectory;			
	protected Text fileIdText;
	protected Button browseFile;	

	protected Text classNameText;
	
    protected boolean isDisplaying;
    protected StaticParserSensorType currentSelection;
    protected StaticParserSensorTypeItemProvider itemProvider;
    protected SensorItemProviderAdapterFactory itemFactory;
	
	
	public StaticParserSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new SensorItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 3;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_STATICPS_DIR"), SWT.NONE);	
		directoryText = factory.createText(this, "", SWT.NULL);
		directoryText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));				
		browseDirectory = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE"), SWT.PUSH);		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_STATICPS_FILE"), SWT.NONE);	
		fileIdText = factory.createText(this, "", SWT.NULL);
		fileIdText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		browseFile = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("BROWSE2"), SWT.PUSH);		

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 3;
		label.setLayoutData(data);		
		
		Composite converterGrp = factory.createComposite(this);
		detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		converterGrp.setLayout(detailLayout);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 3;		
		converterGrp.setLayoutData(data);
		
		label = factory.createLabel(converterGrp, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		label = factory.createLabel(converterGrp, AcadEditorPlugin.getPlugin().getString("STR_STATICPS_PARSER"), SWT.NONE);	
		classNameText = factory.createText(converterGrp, "", SWT.NULL);
		classNameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		directoryText.addModifyListener(this);
		classNameText.addModifyListener(this);
		
		fileIdText.addModifyListener(this);
		browseDirectory.addSelectionListener(this);
		browseFile.addSelectionListener(this);
		
		itemProvider = (StaticParserSensorTypeItemProvider)itemFactory.createStaticParserSensorTypeAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {

		if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)((StaticParserSensorType)object).eContainer().eContainer());

		if(currentSelection == object)
		  return;
        
		if(directoryText.isFocusControl() || fileIdText.isFocusControl()
		   || classNameText.isFocusControl() )
		   
		  return;
        
		currentSelection = (StaticParserSensorType)object;
		isDisplaying = true;
			
		directoryText.setText(currentSelection.getDirectory()==null?"":currentSelection.getDirectory());
		fileIdText.setText(currentSelection.getFileName()==null?"":currentSelection.getFileName());
		classNameText.setText(currentSelection.getParserClassName()==null?"":currentSelection.getParserClassName());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (StaticParserSensorType)currentSelection;
		
		this.currentSelection.setDirectory(directoryText.getText());
		this.currentSelection.setFileName(fileIdText.getText());
		this.currentSelection.setParserClassName(classNameText.getText());
		
		return false;

	}
	
	public void setFocusToText(){
	        directoryText.setFocus();
	        directoryText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == directoryText)
		{
			String text = directoryText.getText();
			if(!text.equals(currentSelection.getDirectory()))
			{
				if(text.length() == 0 && currentSelection.getDirectory() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						StaticParserSensorTypeItemProvider.DIRECTORY);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == fileIdText)
		{
			String text = fileIdText.getText();
			if(!text.equals(currentSelection.getFileName()))
			{
				if(text.length() == 0 && currentSelection.getFileName() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						StaticParserSensorTypeItemProvider.FILE_NAME);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		if(e.getSource() == classNameText)
		{
			String text = classNameText.getText();
			if(!text.equals(currentSelection.getParserClassName()))
			{
				if(text.length() == 0 && currentSelection.getParserClassName() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						StaticParserSensorTypeItemProvider.CLASS_NAME);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

	public void widgetSelected(SelectionEvent e)
	{
		if(e.getSource() == browseDirectory)
		{
			DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
			dialog.setMessage("Select a directory");
			String dirName = directoryText.getText();			
			if(dirName.length() > 0)			  
				dialog.setFilterPath(dirName);
			
			String selectedDirectory = dialog.open();
			if (selectedDirectory != null)
				directoryText.setText(selectedDirectory);						
		}
		else if(e.getSource() == browseFile)
		{
			FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
			String dirName = directoryText.getText();
			if(dirName.length() > 0 && (new File(dirName)).exists())			  
				dialog.setFileName(dirName.concat(File.separator).concat("*"));
				
			String selectedFile = dialog.open();
			if (selectedFile != null)
			{
				File file = new File(selectedFile);
				if(file.exists())
				{
					directoryText.setText(file.getParent());
					fileIdText.setText(file.getName());
					 
				}
			}
			
		}
	}

}
