/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DeleteRowGroupAction extends SelectionProviderAction {
	private DatapoolTable table;

	public DeleteRowGroupAction(ISelectionProvider viewer, DatapoolTable table)
	{
		super(viewer, TestUIPlugin.getString("DEL_ROW_GRP_TEXT"));
		setDescription(TestUIPlugin.getString("DEL_ROW_GRP_LDESC"));
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.DEL_ROW_GRP_ACT);
		this.table = table;
	}

	public void run()
	{
		if (table != null)
			table.deleteRowGroup();
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}
	
}
