/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class CommonEventSection 
extends EditorSection implements IHyperlinkListener
{	 
	private StyledText timeText;
	private SelectableFormLabel modelElementLink;
	private StyledText messageText;
	
	private TPFExecutionEvent executionEvent;

	/**
	 * Constructor for NamedElementSection
	 * @param editorForm 
	 */
	public CommonEventSection(EditorForm editorForm)
	{
		super(editorForm);
		setCollapsable(true);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		executionEvent = null;
		super.dispose();
	}

	protected TPFExecutionEvent getExecutionEvent()
	{
		return executionEvent;
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.update.ui.forms.internal.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
				
		modelElementLink = widgetFactory.createSelectableLabel(composite, "");
		modelElementLink.setText(TestUIPlugin.getString("NO_INTF_TO_INV"));
		modelElementLink.setToolTipText(TestUIPlugin.getString("TIP_EXE_ELEM"));
		widgetFactory.turnIntoHyperlink(modelElementLink, this);

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_TIME"));
		timeText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		timeText.setLayoutData(GridDataUtil.createHorizontalFill());
		timeText.setEditable(false);

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_TEXT"));
		messageText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = 4*messageText.getLineHeight();
		messageText.setLayoutData(gridData);
		messageText.setEditable(false);
								
		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		executionEvent = null;

		timeText.removeVerifyKeyListener(this);
		messageText.removeVerifyKeyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof TPFExecutionEvent)
		{
			executionEvent = (TPFExecutionEvent)object;
			
			timeText.setText(EventUtil.getTime(getExecutionEvent().getTimestamp()));
			
			String value = getExecutionEvent().getText();
			if(value != null)
				messageText.setText(value);
			else
				messageText.setText("");	
				
			TPFTest test = null;
			if((executionEvent.getExecutionHistory() != null) && (executionEvent.getExecutionHistory().getExecutionResult() != null))
				test = executionEvent.getExecutionHistory().getExecutionResult().getTest();

			BVRInteractionFragment interactionFragment = executionEvent.getInteractionFragment();
			if(interactionFragment != null)
			{
				if(interactionFragment.getName() != null)
					modelElementLink.setText(interactionFragment.getName());
				else
					modelElementLink.setText(TestUIPlugin.getString("W_ELEMENT"));
					
				modelElementLink.setData(interactionFragment);
			}
			else if(test != null)
			{
				if(test.getName() != null)
					modelElementLink.setText(test.getName());
				else
					modelElementLink.setText(TestUIPlugin.getString("W_TEST"));
					
				modelElementLink.setData(test);
			}
			else
			{
				modelElementLink.setText(TestUIPlugin.getString("NO_INTF_TO_INV"));
				modelElementLink.setData(null);
			}
		}
		else
		{
			timeText.setText("");
			messageText.setText("");
			modelElementLink.setText(TestUIPlugin.getString("NO_INTF_TO_INV"));

			timeText.setEditable(false);
			messageText.setEditable(false);			
		}
		
		modelElementLink.pack(true);
		modelElementLink.redraw();
		
		timeText.addVerifyKeyListener(this);
		messageText.addVerifyKeyListener(this);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return getExecutionEvent();
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection()
	{
		if(getExecutionEvent() == null)
			return StructuredSelection.EMPTY;
		return new StructuredSelection(getExecutionEvent());
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{

	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkActivated(org.eclipse.swt.widgets.Control)
	 */
	public void linkActivated(Control linkLabel)
	{
		Object data = linkLabel.getData();
		if(data != null)
		{
			EObject eObject = (EObject)data;
			IFile file = EMFUtil.getWorkspaceFile(eObject);
			if(file != null)
			{
				IEditorPart editorPart = UIUtil.openEditor(file, null, false);
				if(editorPart instanceof ISelectionProvider)
					((ISelectionProvider)editorPart).setSelection(new StructuredSelection(eObject));
				
				return;
			}
		}
		
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setErrorMessage(TestUIPlugin.getString("MSG_UN_OPEN_OBJ"));	
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkEntered(org.eclipse.swt.widgets.Control)
	 */
	public void linkEntered(Control linkLabel)
	{
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setMessage(((SelectableFormLabel)linkLabel).getText());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkExited(org.eclipse.swt.widgets.Control)
	 */
	public void linkExited(Control linkLabel)
	{
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
		{
			manager.setMessage("");
			manager.setErrorMessage("");
		}
	}	
}