/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class DeploymentForm 
extends EditorForm
{	
	private int locationPageIndex;

	private NamedElementSection namedElementSection;	
	private NamedElementsSection locationsSection;

	
	/**
	 * Constructor for DeploymentForm
	 * @param deploymentEditorExtension
	 * @param widgetFactory
	 */
	public DeploymentForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory)
	{
		super(deploymentEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT"));
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		namedElementSection.dispose();
		namedElementSection = null;
		
		locationsSection.dispose();
		locationsSection = null;

		super.dispose();
	}

	/**
	 * Returns the deployment manipulated by this form.
	 * @return TPFDeployment
	 */
	protected TPFDeployment getDeployment()
	{
		return ((DeploymentEditorExtension)getBaseEditorExtension()).getDeployment();		
	}

	/**
	 * Sets the index of the location page that is presented when the "more" button
	 * of the location section is pressed. 
	 * @param index
	 */
	public void setLocationPageIndex(int index)
	{
		locationPageIndex = index;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.DEPL_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);

		Control control = createGenericInformation(leftColumn);
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.DEPL_NAME_FORM);								

		locationsSection = new NamedElementsSection(getBaseEditorExtension(), locationPageIndex);
		registerSection(locationsSection);
		locationsSection.createControl(rightColumn, factory, TestUIPlugin.getString("W_LOCS"), TestUIPlugin.getString("EDT_LOC_DSC"));
	}
	
	/**
	 * Creates the generic information form section.
	 * @return FormSection
	 */
	protected Control createGenericInformation(Composite parent)
	{
		namedElementSection = new NamedElementSection(this)
		{
			private StyledText fileText;
			
			protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
			{
				Composite detailComposite = getWidgetFactory().createComposite(parent);
				GridLayout gridLayout = new GridLayout(2, false);
				gridLayout.marginHeight = 0;
				gridLayout.marginWidth = 0;
				detailComposite.setLayout(gridLayout);
				detailComposite.setLayoutData(GridDataUtil.createHorizontalFill());

				getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_FILE"));
				fileText = getWidgetFactory().createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
				fileText.setEnabled(false);
				fileText.setLayoutData(GridDataUtil.createHorizontalFill());
				WorkbenchHelp.setHelp(fileText, TestUIPlugin.getID() + ContextIds.DEPL_TEXT_FORM);								
				
			}
			
			public void setInput(Object object)
			{
				super.setInput(object);
				
				IFile file = EMFUtil.getWorkspaceFile(getDeployment());
				if(file != null)
					fileText.setText(file.getFullPath().toString());						
			}
		};
		registerSection(namedElementSection);		
		namedElementSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
		namedElementSection.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC"));
		return namedElementSection.createControl(parent, getWidgetFactory());
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		namedElementSection.setInput(getDeployment());
		locationsSection.initialize(getDeployment(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), null);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
		String title = ((IWorkbenchAdapter)((IAdaptable)getDeployment()).getAdapter(IWorkbenchAdapter.class)).getLabel(getDeployment());
		if(title != null)
			getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		return true;
	}
}
