/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.hyades.test.ui.TestUIPlugin;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class EventUtil
{
	public final static String TIME_FORMAT = "yyyy.MM.dd - hh:mm:ss a";

	/**
	 * Returns the time given the timestamp used in the event.  If the timestamp
	 * is not valid this method returns an empty string.
	 * @param timestamp
	 * @return a not <code>null</code> String
	 */
	public static String getTime(long timestamp)
	{
		if(timestamp != 0)
		{
			try
			{
				SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
				return format.format(new Date(timestamp));
			}
			catch (RuntimeException e)
			{
				TestUIPlugin.logError(e);
			}
		}
		
		return "";		
	}
}
