/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage;

/**
 * Wizard page for specifying the filename and path for the recorded trace
 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage
 * @author Ernest Jessee
 */
public class HttpRecorderFileSelectPage extends FileLocationSelectionWizardpage
{
	public String getDescription()
	{
		return HttpRecorderPlugin.getResourceString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_DESCRIPTION"); //$NON-NLS-1$
	}

	
	public String getFileExtension()
	{
		return "rec"; //$NON-NLS-1$
	}

	
	public String getFileNameLabel()
	{
		return HttpRecorderPlugin.getResourceString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_FILENAME_LABEL"); //$NON-NLS-1$
	}

	
	
	public String getTitle()
	{
		return HttpRecorderPlugin.getResourceString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_TITLE"); //$NON-NLS-1$
	}

	
	public String getContextHelpID()
	{
		return "org.eclipse.hyades.execution.recorder.http.RecordingLocationSelector"; //$NON-NLS-1$
	}

}
