/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.TestSuiteLocationSelectionPage;

/**
 * Wizard which launches the HttpProxyRecorder
 * @see org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard
 * @author Ernest Jessee
 */
public class HttpRecorderLaunchWizard extends RecorderWizard
{

	private HttpRecorderFileSelectPage fileSelectPage;


	private TestSuiteLocationSelectionPage testLocationPage;


	public void run(IProgressMonitor mon) 
	{	
		if(RecorderFactory.getInstance().getActiveRecorder()!=null)
		{
			RecorderPlugin.reportExceptionToUser(new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR")), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"), //$NON-NLS-1$
												HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_ERROR"));  //$NON-NLS-1$
			return;
		}
		
		Recorder recorder=null;
				
		try
		{
			String recorderParams = "port,"+HttpRecorderPlugin.getPreference(HttpRecorderPlugin.PROXY_PORT); //$NON-NLS-1$
			String recordingFileName = fileSelectPage.getSelectedFilePath();
			HttpRecorderPlugin.storePreference(HttpRecorderPlugin.RECORDING_PATH,recordingFileName);			
			recorder = HttpRecorderPlugin.getDefault().getRecorder();
			recorder.setConfigParams(recorderParams);
			recorder.setRecordingPath(recordingFileName);
			
			recorder.setScriptgenID(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.TEST_GENERATOR));
			if(testLocationPage!=null)
				recorder.setTestPath(testLocationPage.getSelectedFilePath());

			//TODO Need better place for testkeys file 
			//copy testkeys from pluginroot to c:\ if not present 
			URL resolvedTestkeys = Platform.resolve(new URL(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL(), "testkeys"));
			String keyfile = resolvedTestkeys.toString(); 
			if (resolvedTestkeys.getProtocol().equals("file"))
			{
				keyfile = resolvedTestkeys.getFile();
			}
			File file = new File(keyfile);
			if (file.exists())
			{
				File destFile = new File("C:\\testkeys");
				if (destFile.createNewFile()) //only creates if no file exists
				{
					try {
						FileOutputStream out = new FileOutputStream(destFile);
						FileInputStream in = new FileInputStream(file);
						byte[] read = new byte[256];
						int nLen;
						while ((nLen = in.read(read)) != -1)
						{						
							out.write(read, 0, nLen);
						}
						out.flush();
						out.close();
						in.close();
					}
					catch (IOException ioe) {}
				}
			}
 			String adapterID = HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER);
			// recorder.setApplicationAdapterID(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER));
			recorder.setApplicationAdapterID(adapterID);
			if (!(adapterID.equalsIgnoreCase("-1")))
				RecorderAppAdapterFactory.getInstance().getClient(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER)).setInitString(recorderParams);			
			recorder.Record();
		}
		catch (Exception e)
		{
			if(recorder!=null)	
				recorder.setActive(false);
			e.printStackTrace();
			RecorderControlView.getInstance().addMessage(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE")+e.getMessage()); //$NON-NLS-1$
		} 
		
		
		
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{		
		
		addPage(fileSelectPage = new HttpRecorderFileSelectPage());		
		if(!HttpRecorderPlugin.getPreference(HttpRecorderPlugin.TEST_GENERATOR).equalsIgnoreCase("-1")) //$NON-NLS-1$
			addPage(testLocationPage = new TestSuiteLocationSelectionPage());
	}
		
	
	

}
