/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.test.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.eclipse.hyades.ui.internal.util.IDGenerator;
import org.eclipse.hyades.ui.internal.util.StringUtil;

/**
 * Constains the methods to test the 
 * {@link org.eclipse.hyades.ui.internal.util.IDGenerator} class.
 *  
 * @author marcelop
 * @since 0.2.0
 */
public class IDGeneratorTest
extends TestCase
{
	/**
	 * Constructor for IDGeneratorTest
	 * @param name
	 */
	public IDGeneratorTest(String name)
	{
		super(name);
	}

	/**
	 * Returns a suite with the tests defined in this class.
	 * @return Test
	 */
	public static Test suite()
	{
		TestSuite testSuite = new TestSuite("Hyades UI ID Generator");
		testSuite.addTestSuite(IDGeneratorTest.class);
		return testSuite;
	}
	
	/**
	 * Test for one instance of {@link IDGeneratorTest#generateID()}
	 */
	public void testOneIDGenerator()
	{
		final Collection set = new HashSet();
		final IDGenerator generator = new IDGenerator();
		
		set.add(generator.generateID());
		set.add(generator.generateID());
		set.add(generator.generateID());
		assertEquals(3, set.size());
		
		Runnable runnable = new Runnable()
		{
			public void run()
			{
				set.add(generator.generateID());

				try
				{
					Thread.sleep((long)(100*Math.random()));
				}
				catch (InterruptedException e)
				{
				}
				
				set.add(generator.generateID());
				set.add(generator.generateID());				
			}
		};
		
		Thread thread1 = new Thread(runnable);
		Thread thread2 = new Thread(runnable);
		Thread thread3 = new Thread(runnable);
		
		try
		{
			thread1.start(); thread1.join();
			thread2.start(); thread2.join();
			thread3.start(); thread3.join();
		}
		catch (InterruptedException e)
		{
		}
		
		assertEquals(12, set.size());
		for (Iterator i = set.iterator(); i.hasNext();)
			assertTrue(StringUtil.isDigits((String)i.next()));
	}
	
	/**
	 * Test for multiple instances of {@link IDGeneratorTest#generateID()}
	 */
	public void testMultipleIDGenerator()
	{
		final Collection set = new HashSet();
		
		set.add(new IDGenerator().generateID());
		set.add(new IDGenerator().generateID());
		set.add(new IDGenerator().generateID());
		assertEquals(3, set.size());
		
		Runnable runnable = new Runnable()
		{
			public void run()
			{
				set.add(new IDGenerator().generateID());

				try
				{
					Thread.sleep((long)(100*Math.random()));
				}
				catch (InterruptedException e)
				{
				}
				
				set.add(new IDGenerator().generateID());
				set.add(new IDGenerator().generateID());				
			}
		};
		
		Thread thread1 = new Thread(runnable);
		Thread thread2 = new Thread(runnable);
		Thread thread3 = new Thread(runnable);
		
		try
		{
			thread1.start(); thread1.join();
			thread2.start(); thread2.join();
			thread3.start(); thread3.join();
		}
		catch (InterruptedException e)
		{
		}
		
		assertEquals(12, set.size());
		for (Iterator i = set.iterator(); i.hasNext();)
			assertTrue(StringUtil.isDigits((String)i.next()));
	}	
}
