/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * @author ejessee
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ResultsSelectionWizardPage extends WizardPage
{

	HashMap resultsHash = new HashMap();
	
	private List results = null;
	
	private TPFExecutionResult selectedResult = null;
	/**
	 * @param pageName
	 */
	public ResultsSelectionWizardPage(List results)
	{
		super("");
		this.results = results;
	}

	

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite grandParent)
	{
		grandParent.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Composite parent = new Composite(grandParent,SWT.NULL);
		parent.setLayout(new GridLayout(1,true));
		
		setTitle("HTTP Report Generator");
		setDescription("Select result for report");
			
		
		final org.eclipse.swt.widgets.List listWidget = new org.eclipse.swt.widgets.List(parent,SWT.BORDER);
		listWidget.setLayoutData(new GridData(GridData.FILL_BOTH));
		Iterator iter = results.iterator();
		while(iter.hasNext())
		{
			TPFExecutionResult result = (TPFExecutionResult)iter.next();
			String resultName = result.getName();
			listWidget.add(result.getName());
			resultsHash.put(resultName,result);
		}
		
		listWidget.addSelectionListener
		(
			new SelectionListener()
			{
				public void widgetSelected(SelectionEvent event)
				{
					String selectedResultName = listWidget.getSelection()[0];
					selectedResult = (TPFExecutionResult)resultsHash.get(selectedResultName);
					setPageComplete(true);
				}
				
				public void widgetDefaultSelected(SelectionEvent event)
				{
					widgetSelected(event);
				}
			
			}
		);
		setControl(parent);
		
		

	}

	/**
	 * @return
	 */
	public TPFExecutionResult getSelectedResult()
	{
		return selectedResult;
	}

}
