/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFLoopEvent}.
 * 
 * @author jtoomey
 */
public class LoopEvent 
extends ExecutionEvent
{
	private boolean asychronous = false;
	private long iterations = 0;

	/**
	 * @return whether or not the loop is asychronous
	 */
	public boolean isAsychronous() {
		return asychronous;
	}

	/**
	 * @return the number of iterations in the loop
	 */
	public long getIterations() {
		return iterations;
	}

	/**
	 * @param whether or not the loop is asychronous
	 */
	public void setAsychronous(boolean b) {
		asychronous = b;
	}

	/**
	 * @param the number of iterations in the loop
	 */
	public void setIterations(long l) {
		iterations = l;
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot()
	{
		return "loopEvent";
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		super.addXMLAttributes(xml);
		
		xml.append(XMLUtil.createXMLAttribute("iterations", Long.toString(iterations), false));
		if (asychronous)
			xml.append(XMLUtil.createXMLAttribute("asychronous", "true", false));
		else
			xml.append(XMLUtil.createXMLAttribute("asychronous", "false", false));
						

	}	

}
