/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual.internal.editor;

import org.eclipse.hyades.test.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.manual.TestManualPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class ManualEditorExtension 
extends TestSuiteEditorExtension
{
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.manual.internal.editor.ManualEditorExtension";

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages()
	{
		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();
		WidgetFactory widgetFactory = new WidgetFactory();
		
		setTestSuiteForm(new ManualForm(this, widgetFactory));
		getTestSuiteForm().setTestCasePageIndex(PAGE_TEST_CASES);
		hyadesEditorPart.addPage(getTestSuiteForm().createControl());
		hyadesEditorPart.setPageText(PAGE_OVERVIEW, TestManualPlugin.getString("W_OVERVIEW"));

		setTestCasesForm(new ManualTestCasesForm(this, widgetFactory));
		hyadesEditorPart.addPage(getTestCasesForm().createControl());
		hyadesEditorPart.setPageText(PAGE_TEST_CASES, TestManualPlugin.getString("W_TST_CASES"));
		
		setBehaviorForm(new ManualBehaviorForm(this, widgetFactory));
		hyadesEditorPart.addPage(getBehaviorForm().createControl());
		hyadesEditorPart.setPageText(PAGE_BEHAVIOR, TestManualPlugin.getString("W_BEHAVIOR"));
		
		getTestSuiteForm().updateTitle();
	}
}