/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;


public class HyadesExtendedResourceFactory extends ResourceFactoryImpl {
    //~ Constructors -------------------------------------------------------------------------------

    public  HyadesExtendedResourceFactory() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public Resource createResource(URI uri) {
    	List notLoaded = new ArrayList();
    	notLoaded.add(HierarchyPackage.eINSTANCE.getAbstractDefaultEvent());
    	notLoaded.add(HierarchyPackage.eINSTANCE.getTRCAgentProxy());
    	return HyadesResourceExtensions.getInstance().createResource(uri,notLoaded);
    }
}
