/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.trace.internal.loader;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.internal.loader.*;
import org.eclipse.hyades.sd.ui.internal.model.*;

public class TRCNodeLoader extends TRCModelLoaderUtility implements IModelLoader
{
  private TRCNode node = null;

  public TRCNodeLoader()
  {
  }
  
  public TRCNodeLoader(TRCNode trcNode, Graph inputGraph)
  {
    TRCNodeLoader loader = new TRCNodeLoader();
    node = trcNode;
    graph = inputGraph;
  }
  
  public void setObjectAndGraph(Object mObject, Graph gr){
	node = (TRCNode)mObject;
	graph = gr;
  }
  
  private void setNode(TRCNode trcNode)
  {
    node = trcNode;
  }
  private TRCNode getNode()
  {
    return node;
  }

  public void load()
  {
    if (node != null)
    {
    	loadAllAgents(node);
    	syncAgentTimes();
    	loadInvocationsIntoModel(node,graph.getType());
    }
  }
}
