/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.trace.internal.loader;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.internal.loader.*;
import org.eclipse.hyades.sd.ui.internal.model.*;

public class TRCProcessProxyLoader extends TRCModelLoaderUtility implements IModelLoader
{
  private TRCProcessProxy processProxy = null;

  public TRCProcessProxyLoader()
  {
  }

  public TRCProcessProxyLoader(TRCProcessProxy trcProxy, Graph inputGraph)
  {
    TRCProcessProxyLoader loader = new TRCProcessProxyLoader();
    processProxy = trcProxy;
    graph = inputGraph;
  }

  public void setObjectAndGraph(Object mObject, Graph gr){
	processProxy = (TRCProcessProxy)mObject;
	graph = gr;
  } 

  private void setProcessProxy(TRCProcessProxy processProxy)
  {
    this.processProxy = processProxy;
  }
  private TRCProcessProxy getProcessProxy()
  {
    return processProxy;
  }

  public void load()
  {
    if (processProxy != null)
    {
 
    	loadAllAgents(processProxy);
    	syncAgentTimes();
    	loadInvocationsIntoModel(processProxy,graph.getType());
    }
  }
}
