/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.context.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.impl.AdapterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ConfigurationPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.Context;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.context.Contexts;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextsType;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.impl.FormatterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;

import org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitPackage;

import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.UnitPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ContextPackageImpl extends EPackageImpl implements ContextPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass componentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextsTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum roleNamesEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ContextPackageImpl() {
		super(eNS_URI, ContextFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ContextPackage init() {
		if (isInited) return (ContextPackage)EPackage.Registry.INSTANCE.get(ContextPackage.eNS_URI);

		// Obtain or create and register package.
		ContextPackageImpl theContextPackage = (ContextPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ContextPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)(EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) : UnitPackageImpl.eINSTANCE);
		ExtractorPackageImpl theExtractorPackage = (ExtractorPackageImpl)(EPackage.Registry.INSTANCE.get(ExtractorPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ExtractorPackage.eNS_URI) : ExtractorPackageImpl.eINSTANCE);
		FormatterPackageImpl theFormatterPackage = (FormatterPackageImpl)(EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) : FormatterPackageImpl.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) : SensorPackageImpl.eINSTANCE);
		OutputterPackageImpl theOutputterPackage = (OutputterPackageImpl)(EPackage.Registry.INSTANCE.get(OutputterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(OutputterPackage.eNS_URI) : OutputterPackageImpl.eINSTANCE);
		ConfigurationPackageImpl theConfigurationPackage = (ConfigurationPackageImpl)(EPackage.Registry.INSTANCE.get(ConfigurationPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ConfigurationPackage.eNS_URI) : ConfigurationPackageImpl.eINSTANCE);
		ParserPackageImpl theParserPackage = (ParserPackageImpl)(EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) : ParserPackageImpl.eINSTANCE);
		AdapterPackageImpl theAdapterPackage = (AdapterPackageImpl)(EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) : AdapterPackageImpl.eINSTANCE);

		// Step 1: create meta-model objects
		theContextPackage.createPackageContents();
		theUnitPackage.createPackageContents();
		theExtractorPackage.createPackageContents();
		theFormatterPackage.createPackageContents();
		theSensorPackage.createPackageContents();
		theOutputterPackage.createPackageContents();
		theConfigurationPackage.createPackageContents();
		theParserPackage.createPackageContents();
		theAdapterPackage.createPackageContents();

		// Step 2: complete initialization
		theContextPackage.initializePackageContents();
		theUnitPackage.initializePackageContents();
		theExtractorPackage.initializePackageContents();
		theFormatterPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();
		theOutputterPackage.initializePackageContents();
		theConfigurationPackage.initializePackageContents();
		theParserPackage.initializePackageContents();
		theAdapterPackage.initializePackageContents();

		return theContextPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getComponent() {
		return componentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_Description() {
		return (EAttribute)componentEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ExecutableClass() {
		return (EAttribute)componentEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ImplementationCreationDate() {
		return (EAttribute)componentEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ImplementationVersion() {
		return (EAttribute)componentEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ImplementationVersionDescription() {
		return (EAttribute)componentEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_LoggingLevel() {
		return (EAttribute)componentEClass.getEAttributes().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_Name() {
		return (EAttribute)componentEClass.getEAttributes().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_Role() {
		return (EAttribute)componentEClass.getEAttributes().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_RoleCreationDate() {
		return (EAttribute)componentEClass.getEAttributes().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_RoleVersion() {
		return (EAttribute)componentEClass.getEAttributes().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_RoleVersionDescription() {
		return (EAttribute)componentEClass.getEAttributes().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_UniqueID() {
		return (EAttribute)componentEClass.getEAttributes().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getComponent_Component() {
		return (EReference)componentEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContextType() {
		return contextTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_Description() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ExecutableClass() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ImplementationCreationDate() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ImplementationVersion() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ImplementationVersionDescription() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_LoggingLevel() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_Name() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_Role() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_RoleCreationDate() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_RoleVersion() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_RoleVersionDescription() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_UniqueID() {
		return (EAttribute)contextTypeEClass.getEAttributes().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextType_Component() {
		return (EReference)contextTypeEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContextsType() {
		return contextsTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextsType_Context() {
		return (EReference)contextsTypeEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContext() {
		return contextEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContexts() {
		return contextsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getRoleNames() {
		return roleNamesEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContextFactory getContextFactory() {
		return (ContextFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		componentEClass = createEClass(COMPONENT);
		createEAttribute(componentEClass, COMPONENT__DESCRIPTION);
		createEAttribute(componentEClass, COMPONENT__EXECUTABLE_CLASS);
		createEAttribute(componentEClass, COMPONENT__IMPLEMENTATION_CREATION_DATE);
		createEAttribute(componentEClass, COMPONENT__IMPLEMENTATION_VERSION);
		createEAttribute(componentEClass, COMPONENT__IMPLEMENTATION_VERSION_DESCRIPTION);
		createEAttribute(componentEClass, COMPONENT__LOGGING_LEVEL);
		createEAttribute(componentEClass, COMPONENT__NAME);
		createEAttribute(componentEClass, COMPONENT__ROLE);
		createEAttribute(componentEClass, COMPONENT__ROLE_CREATION_DATE);
		createEAttribute(componentEClass, COMPONENT__ROLE_VERSION);
		createEAttribute(componentEClass, COMPONENT__ROLE_VERSION_DESCRIPTION);
		createEAttribute(componentEClass, COMPONENT__UNIQUE_ID);
		createEReference(componentEClass, COMPONENT__COMPONENT);

		contextTypeEClass = createEClass(CONTEXT_TYPE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__DESCRIPTION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__EXECUTABLE_CLASS);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__IMPLEMENTATION_CREATION_DATE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__IMPLEMENTATION_VERSION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__IMPLEMENTATION_VERSION_DESCRIPTION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__LOGGING_LEVEL);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__NAME);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE_CREATION_DATE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE_VERSION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE_VERSION_DESCRIPTION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__UNIQUE_ID);
		createEReference(contextTypeEClass, CONTEXT_TYPE__COMPONENT);

		contextsTypeEClass = createEClass(CONTEXT_STYPE);
		createEReference(contextsTypeEClass, CONTEXT_STYPE__CONTEXT);

		contextEClass = createEClass(CONTEXT);

		contextsEClass = createEClass(CONTEXT_S);

		// Create enums
		roleNamesEEnum = createEEnum(ROLE_NAMES);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Add supertypes to classes
		contextEClass.getESuperTypes().add(this.getContextType());
		contextsEClass.getESuperTypes().add(this.getContextsType());

		// Initialize classes and features; add operations and parameters
		initEClass(componentEClass, Component.class, "Component", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getComponent_Description(), ecorePackage.getEString(), "description", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_ExecutableClass(), ecorePackage.getEString(), "executableClass", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_ImplementationCreationDate(), ecorePackage.getEString(), "implementationCreationDate", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_ImplementationVersion(), ecorePackage.getEString(), "implementationVersion", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_ImplementationVersionDescription(), ecorePackage.getEString(), "implementationVersionDescription", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_LoggingLevel(), ecorePackage.getEString(), "loggingLevel", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_Name(), ecorePackage.getEString(), "name", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_Role(), this.getRoleNames(), "role", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_RoleCreationDate(), ecorePackage.getEString(), "roleCreationDate", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_RoleVersion(), ecorePackage.getEString(), "roleVersion", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_RoleVersionDescription(), ecorePackage.getEString(), "roleVersionDescription", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getComponent_UniqueID(), ecorePackage.getEString(), "uniqueID", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE);
		initEReference(getComponent_Component(), this.getComponent(), null, "component", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(contextTypeEClass, ContextType.class, "ContextType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getContextType_Description(), ecorePackage.getEString(), "description", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_ExecutableClass(), ecorePackage.getEString(), "executableClass", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_ImplementationCreationDate(), ecorePackage.getEString(), "implementationCreationDate", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_ImplementationVersion(), ecorePackage.getEString(), "implementationVersion", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_ImplementationVersionDescription(), ecorePackage.getEString(), "implementationVersionDescription", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_LoggingLevel(), ecorePackage.getEString(), "loggingLevel", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_Name(), ecorePackage.getEString(), "name", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_Role(), this.getRoleNames(), "role", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_RoleCreationDate(), ecorePackage.getEString(), "roleCreationDate", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_RoleVersion(), ecorePackage.getEString(), "roleVersion", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_RoleVersionDescription(), ecorePackage.getEString(), "roleVersionDescription", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getContextType_UniqueID(), ecorePackage.getEString(), "uniqueID", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE);
		initEReference(getContextType_Component(), this.getComponent(), null, "component", null, 1, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(contextsTypeEClass, ContextsType.class, "ContextsType", !IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getContextsType_Context(), this.getContextType(), null, "context", null, 1, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(contextEClass, Context.class, "Context", !IS_ABSTRACT, !IS_INTERFACE);

		initEClass(contextsEClass, Contexts.class, "Contexts", !IS_ABSTRACT, !IS_INTERFACE);

		// Initialize enums and add enum literals
		initEEnum(roleNamesEEnum, RoleNames.class, "RoleNames");
		addEEnumLiteral(roleNamesEEnum, RoleNames.SENSOR_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.MESSAGE_EXTRACTOR_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.PARSER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.FORMATTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.MESSAGE_FILTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.CBE_FILTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.OUTPUTTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.CONTEXT_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.UNDECLARED_LITERAL);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore
		createXSD2EcoreAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createXSD2EcoreAnnotations() {
		String source = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "representation", "schema",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (roleNamesEEnum, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "roleNames",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (componentEClass, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "component",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (getComponent_Component(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Component",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (getComponent_Description(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_ExecutableClass(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "executableClass",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_ImplementationCreationDate(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "implementationCreationDate",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_ImplementationVersion(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "implementationVersion",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_ImplementationVersionDescription(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "implementationVersionDescription",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_LoggingLevel(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "loggingLevel",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_Name(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_Role(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "role",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_RoleCreationDate(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "roleCreationDate",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_RoleVersion(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "roleVersion",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_RoleVersionDescription(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "roleVersionDescription",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getComponent_UniqueID(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "uniqueID",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (contextTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "contextType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (getContextType_Component(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Component",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (getContextType_Description(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_ExecutableClass(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "executableClass",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_ImplementationCreationDate(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "implementationCreationDate",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_ImplementationVersion(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "implementationVersion",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_ImplementationVersionDescription(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "implementationVersionDescription",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_LoggingLevel(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "loggingLevel",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_Name(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "name",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_Role(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "role",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_RoleCreationDate(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "roleCreationDate",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_RoleVersion(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "roleVersion",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_RoleVersionDescription(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "roleVersionDescription",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getContextType_UniqueID(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "uniqueID",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (contextsTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "ContextsType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (getContextsType_Context(), 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Context",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (contextEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Context",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });		
		addAnnotation
		  (contextsEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Contexts",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Context.xsd"
		   });
	}
} //ContextPackageImpl
