/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.extractor.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.impl.AdapterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ConfigurationPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;

import org.eclipse.hyades.logging.adapter.model.internal.context.impl.ContextPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.Extractor;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.impl.FormatterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;

import org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitPackage;

import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.UnitPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ExtractorPackageImpl extends EPackageImpl implements ExtractorPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass extractorTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass extractorEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ExtractorPackageImpl() {
		super(eNS_URI, ExtractorFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ExtractorPackage init() {
		if (isInited) return (ExtractorPackage)EPackage.Registry.INSTANCE.get(ExtractorPackage.eNS_URI);

		// Obtain or create and register package.
		ExtractorPackageImpl theExtractorPackage = (ExtractorPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ExtractorPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)(EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(UnitPackage.eNS_URI) : UnitPackageImpl.eINSTANCE);
		FormatterPackageImpl theFormatterPackage = (FormatterPackageImpl)(EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(FormatterPackage.eNS_URI) : FormatterPackageImpl.eINSTANCE);
		ContextPackageImpl theContextPackage = (ContextPackageImpl)(EPackage.Registry.INSTANCE.get(ContextPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ContextPackage.eNS_URI) : ContextPackageImpl.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(SensorPackage.eNS_URI) : SensorPackageImpl.eINSTANCE);
		OutputterPackageImpl theOutputterPackage = (OutputterPackageImpl)(EPackage.Registry.INSTANCE.get(OutputterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(OutputterPackage.eNS_URI) : OutputterPackageImpl.eINSTANCE);
		ConfigurationPackageImpl theConfigurationPackage = (ConfigurationPackageImpl)(EPackage.Registry.INSTANCE.get(ConfigurationPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ConfigurationPackage.eNS_URI) : ConfigurationPackageImpl.eINSTANCE);
		ParserPackageImpl theParserPackage = (ParserPackageImpl)(EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(ParserPackage.eNS_URI) : ParserPackageImpl.eINSTANCE);
		AdapterPackageImpl theAdapterPackage = (AdapterPackageImpl)(EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(AdapterPackage.eNS_URI) : AdapterPackageImpl.eINSTANCE);

		// Step 1: create meta-model objects
		theExtractorPackage.createPackageContents();
		theUnitPackage.createPackageContents();
		theFormatterPackage.createPackageContents();
		theContextPackage.createPackageContents();
		theSensorPackage.createPackageContents();
		theOutputterPackage.createPackageContents();
		theConfigurationPackage.createPackageContents();
		theParserPackage.createPackageContents();
		theAdapterPackage.createPackageContents();

		// Step 2: complete initialization
		theExtractorPackage.initializePackageContents();
		theUnitPackage.initializePackageContents();
		theFormatterPackage.initializePackageContents();
		theContextPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();
		theOutputterPackage.initializePackageContents();
		theConfigurationPackage.initializePackageContents();
		theParserPackage.initializePackageContents();
		theAdapterPackage.initializePackageContents();

		return theExtractorPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExtractorType() {
		return extractorTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_ContainsLineBreaks() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_Description() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_EndPattern() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_IncludeEndPattern() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_IncludeStartPattern() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_LineBreakSymbol() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_ReplaceLineBreaks() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_StartPattern() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExtractorType_UniqueID() {
		return (EAttribute)extractorTypeEClass.getEAttributes().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExtractor() {
		return extractorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtractorFactory getExtractorFactory() {
		return (ExtractorFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		extractorTypeEClass = createEClass(EXTRACTOR_TYPE);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__DESCRIPTION);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__END_PATTERN);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__INCLUDE_END_PATTERN);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__INCLUDE_START_PATTERN);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__LINE_BREAK_SYMBOL);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__REPLACE_LINE_BREAKS);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__START_PATTERN);
		createEAttribute(extractorTypeEClass, EXTRACTOR_TYPE__UNIQUE_ID);

		extractorEClass = createEClass(EXTRACTOR);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Add supertypes to classes
		extractorEClass.getESuperTypes().add(this.getExtractorType());

		// Initialize classes and features; add operations and parameters
		initEClass(extractorTypeEClass, ExtractorType.class, "ExtractorType", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getExtractorType_ContainsLineBreaks(), ecorePackage.getEBoolean(), "containsLineBreaks", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_Description(), ecorePackage.getEString(), "description", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_EndPattern(), ecorePackage.getEString(), "endPattern", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_IncludeEndPattern(), ecorePackage.getEBoolean(), "includeEndPattern", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_IncludeStartPattern(), ecorePackage.getEBoolean(), "includeStartPattern", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_LineBreakSymbol(), ecorePackage.getEString(), "lineBreakSymbol", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_ReplaceLineBreaks(), ecorePackage.getEBoolean(), "replaceLineBreaks", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_StartPattern(), ecorePackage.getEString(), "startPattern", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getExtractorType_UniqueID(), ecorePackage.getEString(), "uniqueID", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

		initEClass(extractorEClass, Extractor.class, "Extractor", !IS_ABSTRACT, !IS_INTERFACE);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore
		createXSD2EcoreAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createXSD2EcoreAnnotations() {
		String source = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";		
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "representation", "schema",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Extractor.xsd"
		   });		
		addAnnotation
		  (extractorTypeEClass, 
		   source, 
		   new String[] {
			 "representation", "type",
			 "name", "ExtractorType",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Extractor.xsd"
		   });		
		addAnnotation
		  (getExtractorType_ContainsLineBreaks(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "containsLineBreaks",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_Description(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "description",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_EndPattern(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "endPattern",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_IncludeEndPattern(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "includeEndPattern",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_IncludeStartPattern(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "includeStartPattern",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_LineBreakSymbol(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "lineBreakSymbol",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_ReplaceLineBreaks(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "replaceLineBreaks",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_StartPattern(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "startPattern",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (getExtractorType_UniqueID(), 
		   source, 
		   new String[] {
			 "representation", "attribute",
			 "name", "uniqueID",
			 "targetNamespace", null
		   });		
		addAnnotation
		  (extractorEClass, 
		   source, 
		   new String[] {
			 "representation", "element",
			 "name", "Extractor",
			 "targetNamespace", "http://www.eclipse.org/hyades/schema/Extractor.xsd"
		   });
	}
} //ExtractorPackageImpl
