/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.outputter.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Logging Agent Outputter Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.LoggingAgentOutputterTypeImpl#getAgentName <em>Agent Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.LoggingAgentOutputterTypeImpl#getWaitUntilLoggingTime <em>Wait Until Logging Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class LoggingAgentOutputterTypeImpl extends EObjectImpl implements LoggingAgentOutputterType {
	/**
	 * The default value of the '{@link #getAgentName() <em>Agent Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAgentName()
	 * @generated
	 * @ordered
	 */
	protected static final String AGENT_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAgentName() <em>Agent Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAgentName()
	 * @generated
	 * @ordered
	 */
	protected String agentName = AGENT_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getWaitUntilLoggingTime() <em>Wait Until Logging Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWaitUntilLoggingTime()
	 * @generated
	 * @ordered
	 */
	protected static final String WAIT_UNTIL_LOGGING_TIME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getWaitUntilLoggingTime() <em>Wait Until Logging Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWaitUntilLoggingTime()
	 * @generated
	 * @ordered
	 */
	protected String waitUntilLoggingTime = WAIT_UNTIL_LOGGING_TIME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LoggingAgentOutputterTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return OutputterPackage.eINSTANCE.getLoggingAgentOutputterType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAgentName() {
		return agentName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAgentName(String newAgentName) {
		String oldAgentName = agentName;
		agentName = newAgentName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__AGENT_NAME, oldAgentName, agentName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getWaitUntilLoggingTime() {
		return waitUntilLoggingTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWaitUntilLoggingTime(String newWaitUntilLoggingTime) {
		String oldWaitUntilLoggingTime = waitUntilLoggingTime;
		waitUntilLoggingTime = newWaitUntilLoggingTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__WAIT_UNTIL_LOGGING_TIME, oldWaitUntilLoggingTime, waitUntilLoggingTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__AGENT_NAME:
				return getAgentName();
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__WAIT_UNTIL_LOGGING_TIME:
				return getWaitUntilLoggingTime();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__AGENT_NAME:
				setAgentName((String)newValue);
				return;
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__WAIT_UNTIL_LOGGING_TIME:
				setWaitUntilLoggingTime((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__AGENT_NAME:
				setAgentName(AGENT_NAME_EDEFAULT);
				return;
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__WAIT_UNTIL_LOGGING_TIME:
				setWaitUntilLoggingTime(WAIT_UNTIL_LOGGING_TIME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__AGENT_NAME:
				return AGENT_NAME_EDEFAULT == null ? agentName != null : !AGENT_NAME_EDEFAULT.equals(agentName);
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE__WAIT_UNTIL_LOGGING_TIME:
				return WAIT_UNTIL_LOGGING_TIME_EDEFAULT == null ? waitUntilLoggingTime != null : !WAIT_UNTIL_LOGGING_TIME_EDEFAULT.equals(waitUntilLoggingTime);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (agentName: ");
		result.append(agentName);
		result.append(", waitUntilLoggingTime: ");
		result.append(waitUntilLoggingTime);
		result.append(')');
		return result.toString();
	}

} //LoggingAgentOutputterTypeImpl
