/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.outputter.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.util.Guid;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Config Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterConfigTypeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterConfigTypeImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterConfigTypeImpl#getUniqueID <em>Unique ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterConfigTypeImpl#getSingleFileOutputterType <em>Single File Outputter Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterConfigTypeImpl#getStandardOutOutputterType <em>Standard Out Outputter Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterConfigTypeImpl#getLoggingAgentOutputterType <em>Logging Agent Outputter Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterConfigTypeImpl#getNotificationOutputterType <em>Notification Outputter Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OutputterConfigTypeImpl extends EObjectImpl implements OutputterConfigType {
	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final OutputterType TYPE_EDEFAULT = OutputterType.STANDARD_OUT_OUTPUTTER_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected OutputterType type = TYPE_EDEFAULT;

	/**
	 * This is true if the Type attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean typeESet = false;

	/**
	 * The default value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected static final String UNIQUE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected String uniqueID = UNIQUE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSingleFileOutputterType() <em>Single File Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSingleFileOutputterType()
	 * @generated
	 * @ordered
	 */
	protected SingleFileOutputterType singleFileOutputterType = null;

	/**
	 * The cached value of the '{@link #getStandardOutOutputterType() <em>Standard Out Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStandardOutOutputterType()
	 * @generated
	 * @ordered
	 */
	protected StandardOutOutputterType standardOutOutputterType = null;

	/**
	 * The cached value of the '{@link #getLoggingAgentOutputterType() <em>Logging Agent Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLoggingAgentOutputterType()
	 * @generated
	 * @ordered
	 */
	protected LoggingAgentOutputterType loggingAgentOutputterType = null;

	/**
	 * The cached value of the '{@link #getNotificationOutputterType() <em>Notification Outputter Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNotificationOutputterType()
	 * @generated
	 * @ordered
	 */
	protected NotificationOutputterType notificationOutputterType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutputterConfigTypeImpl() {
		super();
		
		uniqueID = (new Guid()).toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return OutputterPackage.eINSTANCE.getOutputterConfigType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(OutputterType newType) {
		OutputterType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		boolean oldTypeESet = typeESet;
		typeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE, oldType, type, !oldTypeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetType() {
		OutputterType oldType = type;
		boolean oldTypeESet = typeESet;
		type = TYPE_EDEFAULT;
		typeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE, oldType, TYPE_EDEFAULT, oldTypeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetType() {
		return typeESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUniqueID() {
		return uniqueID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUniqueID(String newUniqueID) {
		
		String oldUniqueID = uniqueID;
		uniqueID = newUniqueID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__UNIQUE_ID, oldUniqueID, uniqueID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SingleFileOutputterType getSingleFileOutputterType() {
		return singleFileOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSingleFileOutputterType(SingleFileOutputterType newSingleFileOutputterType, NotificationChain msgs) {
		SingleFileOutputterType oldSingleFileOutputterType = singleFileOutputterType;
		singleFileOutputterType = newSingleFileOutputterType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE, oldSingleFileOutputterType, newSingleFileOutputterType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSingleFileOutputterType(SingleFileOutputterType newSingleFileOutputterType) {
		if (newSingleFileOutputterType != singleFileOutputterType) {
			NotificationChain msgs = null;
			if (singleFileOutputterType != null)
				msgs = ((InternalEObject)singleFileOutputterType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE, null, msgs);
			if (newSingleFileOutputterType != null)
				msgs = ((InternalEObject)newSingleFileOutputterType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE, null, msgs);
			msgs = basicSetSingleFileOutputterType(newSingleFileOutputterType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE, newSingleFileOutputterType, newSingleFileOutputterType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StandardOutOutputterType getStandardOutOutputterType() {
		return standardOutOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStandardOutOutputterType(StandardOutOutputterType newStandardOutOutputterType, NotificationChain msgs) {
		StandardOutOutputterType oldStandardOutOutputterType = standardOutOutputterType;
		standardOutOutputterType = newStandardOutOutputterType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE, oldStandardOutOutputterType, newStandardOutOutputterType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStandardOutOutputterType(StandardOutOutputterType newStandardOutOutputterType) {
		if (newStandardOutOutputterType != standardOutOutputterType) {
			NotificationChain msgs = null;
			if (standardOutOutputterType != null)
				msgs = ((InternalEObject)standardOutOutputterType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE, null, msgs);
			if (newStandardOutOutputterType != null)
				msgs = ((InternalEObject)newStandardOutOutputterType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE, null, msgs);
			msgs = basicSetStandardOutOutputterType(newStandardOutOutputterType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE, newStandardOutOutputterType, newStandardOutOutputterType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LoggingAgentOutputterType getLoggingAgentOutputterType() {
		return loggingAgentOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLoggingAgentOutputterType(LoggingAgentOutputterType newLoggingAgentOutputterType, NotificationChain msgs) {
		LoggingAgentOutputterType oldLoggingAgentOutputterType = loggingAgentOutputterType;
		loggingAgentOutputterType = newLoggingAgentOutputterType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE, oldLoggingAgentOutputterType, newLoggingAgentOutputterType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLoggingAgentOutputterType(LoggingAgentOutputterType newLoggingAgentOutputterType) {
		if (newLoggingAgentOutputterType != loggingAgentOutputterType) {
			NotificationChain msgs = null;
			if (loggingAgentOutputterType != null)
				msgs = ((InternalEObject)loggingAgentOutputterType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE, null, msgs);
			if (newLoggingAgentOutputterType != null)
				msgs = ((InternalEObject)newLoggingAgentOutputterType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE, null, msgs);
			msgs = basicSetLoggingAgentOutputterType(newLoggingAgentOutputterType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE, newLoggingAgentOutputterType, newLoggingAgentOutputterType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationOutputterType getNotificationOutputterType() {
		return notificationOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetNotificationOutputterType(NotificationOutputterType newNotificationOutputterType, NotificationChain msgs) {
		NotificationOutputterType oldNotificationOutputterType = notificationOutputterType;
		notificationOutputterType = newNotificationOutputterType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE, oldNotificationOutputterType, newNotificationOutputterType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNotificationOutputterType(NotificationOutputterType newNotificationOutputterType) {
		if (newNotificationOutputterType != notificationOutputterType) {
			NotificationChain msgs = null;
			if (notificationOutputterType != null)
				msgs = ((InternalEObject)notificationOutputterType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE, null, msgs);
			if (newNotificationOutputterType != null)
				msgs = ((InternalEObject)newNotificationOutputterType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE, null, msgs);
			msgs = basicSetNotificationOutputterType(newNotificationOutputterType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE, newNotificationOutputterType, newNotificationOutputterType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE:
					return basicSetSingleFileOutputterType(null, msgs);
				case OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE:
					return basicSetStandardOutOutputterType(null, msgs);
				case OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE:
					return basicSetLoggingAgentOutputterType(null, msgs);
				case OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE:
					return basicSetNotificationOutputterType(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__DESCRIPTION:
				return getDescription();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE:
				return getType();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__UNIQUE_ID:
				return getUniqueID();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE:
				return getSingleFileOutputterType();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE:
				return getStandardOutOutputterType();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE:
				return getLoggingAgentOutputterType();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE:
				return getNotificationOutputterType();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE:
				setType((OutputterType)newValue);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE:
				setSingleFileOutputterType((SingleFileOutputterType)newValue);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE:
				setStandardOutOutputterType((StandardOutOutputterType)newValue);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE:
				setLoggingAgentOutputterType((LoggingAgentOutputterType)newValue);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE:
				setNotificationOutputterType((NotificationOutputterType)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE:
				unsetType();
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE:
				setSingleFileOutputterType((SingleFileOutputterType)null);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE:
				setStandardOutOutputterType((StandardOutOutputterType)null);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE:
				setLoggingAgentOutputterType((LoggingAgentOutputterType)null);
				return;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE:
				setNotificationOutputterType((NotificationOutputterType)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__TYPE:
				return isSetType();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__SINGLE_FILE_OUTPUTTER_TYPE:
				return singleFileOutputterType != null;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__STANDARD_OUT_OUTPUTTER_TYPE:
				return standardOutOutputterType != null;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__LOGGING_AGENT_OUTPUTTER_TYPE:
				return loggingAgentOutputterType != null;
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE__NOTIFICATION_OUTPUTTER_TYPE:
				return notificationOutputterType != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (description: ");
		result.append(description);
		result.append(", type: ");
		if (typeESet) result.append(type); else result.append("<unset>");
		result.append(", uniqueID: ");
		result.append(uniqueID);
		result.append(')');
		return result.toString();
	}

} //OutputterConfigTypeImpl
