/**********************************************************************
* Copyright (c) 2003 Hyades project.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Common Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/cpl-v10.html
* 
* Contributors:
* IBM - Initial API and implementation
**********************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * %W%
 * @version %I% %H%
 */
package org.eclipse.hyades.logging.adapter.model.internal.parser.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttribute;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rule Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class RuleAttributeImpl extends RuleAttributeTypeImpl implements RuleAttribute {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RuleAttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ParserPackage.eINSTANCE.getRuleAttribute();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ParserPackage.RULE_ATTRIBUTE__SUBSTITUTION_RULE:
					return ((InternalEList)getSubstitutionRule()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE__ID:
				return getId();
			case ParserPackage.RULE_ATTRIBUTE__INDEX:
				return getIndex();
			case ParserPackage.RULE_ATTRIBUTE__NAME:
				return getName();
			case ParserPackage.RULE_ATTRIBUTE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				return isUsePreviousMatchSubstitutionAsDefault() ? Boolean.TRUE : Boolean.FALSE;
			case ParserPackage.RULE_ATTRIBUTE__SUBSTITUTION_RULE:
				return getSubstitutionRule();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE__ID:
				setId((String)newValue);
				return;
			case ParserPackage.RULE_ATTRIBUTE__INDEX:
				setIndex((String)newValue);
				return;
			case ParserPackage.RULE_ATTRIBUTE__NAME:
				setName((String)newValue);
				return;
			case ParserPackage.RULE_ATTRIBUTE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				setUsePreviousMatchSubstitutionAsDefault(((Boolean)newValue).booleanValue());
				return;
			case ParserPackage.RULE_ATTRIBUTE__SUBSTITUTION_RULE:
				getSubstitutionRule().clear();
				getSubstitutionRule().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE__ID:
				setId(ID_EDEFAULT);
				return;
			case ParserPackage.RULE_ATTRIBUTE__INDEX:
				setIndex(INDEX_EDEFAULT);
				return;
			case ParserPackage.RULE_ATTRIBUTE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ParserPackage.RULE_ATTRIBUTE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				unsetUsePreviousMatchSubstitutionAsDefault();
				return;
			case ParserPackage.RULE_ATTRIBUTE__SUBSTITUTION_RULE:
				getSubstitutionRule().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ATTRIBUTE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ParserPackage.RULE_ATTRIBUTE__INDEX:
				return INDEX_EDEFAULT == null ? index != null : !INDEX_EDEFAULT.equals(index);
			case ParserPackage.RULE_ATTRIBUTE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ParserPackage.RULE_ATTRIBUTE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
				return isSetUsePreviousMatchSubstitutionAsDefault();
			case ParserPackage.RULE_ATTRIBUTE__SUBSTITUTION_RULE:
				return substitutionRule != null && !substitutionRule.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //RuleAttributeImpl
